<?php
//$startLocation = ['lat' => 8.80661, 'lng' => 78.13493]; // Default values
//$endLocation = ['lat' => 8.806723, 'lng' => 78.135018];

$error = '';

if (isset($_GET['data']) && !empty($_GET['data'])) {

    $encryptedData = $_GET['data'];
    $decryptedData = base64_decode($encryptedData);
    $dataArray = explode('|', $decryptedData);

    if (count($dataArray) === 7) {
        list($employeeId, $customerId, $customerLatitude, $customerLongitude, $employeeLatitude, $employeeLongitude, $workid) = $dataArray;

        
        $startLocation = ['lat' => (float)$employeeLatitude, 'lng' => (float)$employeeLongitude];
        $endLocation = ['lat' => (float)$customerLatitude, 'lng' => (float)$customerLongitude];
        //$endLocation = ['lat' => 8.895218, 'lng' => 78.165344];
    }else {
    $error = "Missing or invalid data. Please provide valid tracking information.";
    }
}else {
    $error = "Missing or invalid data. Please provide valid tracking information.";
}
?>


<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Live Route Tracking</title>
  <style>
    #map { height: 100vh; width: 100%; }
    .top-banner {
      position: absolute;
      top: 10px;
      left: 50%;
      transform: translateX(-50%);
      background: green;
      color: white;
      padding: 10px 20px;
      border-radius: 20px;
      font-size: 18px;
      z-index: 1000;
    }
  </style>
</head>
<body>
    
  <?php if ($error): ?>
 <div class="error-message"><?php echo $error; ?></div>
  <?php else: ?>
  <div class="top-banner">🚖 Arriving in <span id="arrival-time"></span> minutes</div>
  <div id="map"></div>

  <script>
    let map, directionsService, directionsRenderer, userMarker, startMarker, endMarker;
    let locationUpdateInterval; // Declare the variable globally
       let startLocation = <?php echo json_encode($startLocation); ?>;
    let endLocation = <?php echo json_encode($endLocation); ?>;

    //console.log("Start Location:", startLocation);
    //console.log("End Location:", endLocation);


    let lastUserLocation = startLocation;
    let routePath = null;
    const deviationThreshold = 200; // Deviation threshold in meters
    let isFirstLocationUpdate = true;
    
    

    function initMap() {
      map = new google.maps.Map(document.getElementById("map"), {
        center: startLocation,
        zoom: 15,
        disableDefaultUI: true, // Hides UI for a cleaner look
      });

      directionsService = new google.maps.DirectionsService();
      directionsRenderer = new google.maps.DirectionsRenderer({
        suppressMarkers: true, // Hide default markers
        polylineOptions: {
        strokeColor: "#ff2a00",  // Change route line color to red
        strokeOpacity: 1.0,   // Full opacity
        strokeWeight: 5       // Increase line thickness
    }
      });
      directionsRenderer.setMap(map);

      endMarker = new google.maps.Marker({
        position: endLocation,
        map: map,
        icon: {
          url: "http://maps.google.com/mapfiles/ms/icons/red-dot.png"
        }
      });

      // User marker (blue)
      userMarker = new google.maps.Marker({
        position: startLocation,
        map: map,
        icon: "https://maps.google.com/mapfiles/ms/icons/blue-dot.png",
        animation: google.maps.Animation.DROP // Smooth drop animation for initial marker
      });
      

      calculateRoute("DRIVING");
      updateArrivalTime(startLocation);
     // updateUserLocation();
     locationUpdateInterval =  setInterval(updateUserLocation, 4000); // Update every 5 seconds for smoother tracking
    }

   

        function calculateRoute(travelMode) {
            let request = {
                 origin: startLocation,
                 destination: endLocation,
                 //travelMode: 'TRANSIT'
               // origin: 'Kamaraj College, 482, Tiruchendur Rd, CGE Colony, Thoothukudi, Tamil Nadu 628003',
                //destination: 'ZeroSoft Technologies, 4A, 11th St, Toovipuram, Thoothukudi, Tamil Nadu 628003',
                travelMode: 'DRIVING',
            };

            directionsService.route(request, (result, status) => {
                if (status === google.maps.DirectionsStatus.OK) {
                    directionsRenderer.setDirections(result);
                } else {
                    console.error("Error fetching route", status);
                }
            });
        }

          
    let employeeId = "<?php echo isset($employeeId) ? $employeeId : ''; ?>";
    let customerId = "<?php echo isset($customerId) ? $customerId : ''; ?>";
    let workid = "<?php echo isset($workid) ? $workid : ''; ?>";


    async function updateUserLocation() {
  try {
    let response = await fetch(`https://gpsscheduler.com/app/sandbox/ws/Maidtosparkle/getRealtimelocation?employeeId=${employeeId}&customerId=${customerId}&workid=${workid}`);
    let data = await response.json();

    if (!data.data || !data.data.lat || !data.data.lng || (data.data.lat == 0 && data.data.lng == 0)) {
      console.warn("Invalid location detected. Hiding map and displaying error message.");
      document.getElementById("map").style.display = "none";
      document.querySelector(".top-banner").style.display = "none";
      document.body.innerHTML += `<div class="error-message">Location data not available. Please try again later.</div>`;
      clearInterval(locationUpdateInterval); // Stop location updates
      return;
    }


    if (data.data.lat && data.data.lng) {
      let userLocation = { 
        lat: parseFloat(data.data.lat), // Convert to number
        lng: parseFloat(data.data.lng) // Convert to number
      };

      if (userLocation.lat == 0 && userLocation.lng == 0) {
        console.warn("Invalid location detected (0,0). Stopping tracking.");
        clearInterval(locationUpdateInterval); // Stop location updates
        return;
      }

      if (!userMarker) {
        // If the user marker is not set, initialize it
        userMarker = new google.maps.Marker({
          position: userLocation,
          map: map,
          icon: "https://maps.google.com/mapfiles/ms/icons/blue-dot.png",
          animation: google.maps.Animation.DROP,
        });
      }

      // Smoothly animate the marker instead of just jumping
      moveMarker(userMarker, userLocation);

      updateArrivalTime(userLocation);

      if (routePath && isUserOffRoute(userLocation, routePath)) {
        console.log("User deviated from route, recalculating...");
        calculateRoute(userLocation);
      }

      lastUserLocation = userLocation;
    }else{
        console.warn("Invalid location detected (0,0). Stopping tracking.");
        clearInterval(locationUpdateInterval); // Stop location updates
        return;
    }
  } catch (error) {
    console.error("Error fetching user location:", error);
  }
}

// Function to move the marker smoothly
function moveMarker(marker, newPosition) {
  let startPos = marker.getPosition();
  let endPos = new google.maps.LatLng(newPosition.lat, newPosition.lng);

  let deltaLat = (endPos.lat() - startPos.lat()) / 50;
  let deltaLng = (endPos.lng() - startPos.lng()) / 50;

  let step = 0;
  let interval = setInterval(() => {
    step++;
    let lat = startPos.lat() + deltaLat * step;
    let lng = startPos.lng() + deltaLng * step;
    marker.setPosition(new google.maps.LatLng(lat, lng));

    if (step >= 50) {
      clearInterval(interval);
    }
  }, 50); // Update every 50ms for smooth animation
}


    function isUserOffRoute(userLocation, routePath) {
      let minDistance = Infinity;

      for (let i = 0; i < routePath.length; i++) {
        let pathPoint = routePath[i];
        let distance = google.maps.geometry.spherical.computeDistanceBetween(
          new google.maps.LatLng(userLocation.lat, userLocation.lng),
          new google.maps.LatLng(pathPoint.lat(), pathPoint.lng())
        );

        if (distance < minDistance) {
          minDistance = distance;
        }
      }

      return minDistance > deviationThreshold;
    }


    function updateArrivalTime(userLocation) {
  let service = new google.maps.DistanceMatrixService();
  
  service.getDistanceMatrix(
    {
      origins: [userLocation],
      destinations: [endLocation],
      travelMode: "DRIVING",
    },
    function (response, status) {
      if (status === "OK") {
        let duration = response.rows[0].elements[0].duration.value; // Duration in seconds
        let remainingTime = Math.ceil(duration / 60); // Convert to minutes
        document.getElementById("arrival-time").innerText = remainingTime;
      } else {
        console.error("Error calculating arrival time:", status);
      }
    }
  );
}


    // function updateArrivalTime(userLocation) {
    //   let speed = 30; // Speed in km/h
    //   let distance = getDistance(userLocation, endLocation);
    //   let remainingTime = (distance / speed) * 60; // Convert to minutes
    //   document.getElementById("arrival-time").innerText = Math.ceil(remainingTime);
    // }

    function getDistance(coord1, coord2) {
      let R = 6371; // Radius of the Earth in km
      let toRad = (deg) => deg * (Math.PI / 180);
      let dLat = toRad(coord2.lat - coord1.lat);
      let dLon = toRad(coord2.lng - coord1.lng);

      let a = Math.sin(dLat / 2) * Math.sin(dLat / 2) +
              Math.cos(toRad(coord1.lat)) * Math.cos(toRad(coord2.lat)) *
              Math.sin(dLon / 2) * Math.sin(dLon / 2);
      let c = 2 * Math.atan2(Math.sqrt(a), Math.sqrt(1 - a));
      return R * c * 1000; // Convert to meters
    }


    document.addEventListener("visibilitychange", function () {
  if (document.hidden) {
   
    clearInterval(locationUpdateInterval);
  } else {
    
    //updateUserLocation();
    locationUpdateInterval = setInterval(updateUserLocation, 4000);
  }
});



  </script>

  <script type="text/javascript" 
    src="https://maps.googleapis.com/maps/api/js?key=AIzaSyBiiThj7Bn5N77CTEmb9Dk_YJOFRvDeLtg&callback=initMap&libraries=places,geometry">
  </script>
  <?php endif; ?>

</body>
</html>
