<?php
//$startLocation = ['lat' => 8.80661, 'lng' => 78.13493]; // Default values
//$endLocation = ['lat' => 8.806723, 'lng' => 78.135018];


$startLocation = ['lat' => (float)'8.80393', 'lng' => (float)'78.14382'];
$endLocation = ['lat' => (float)'8.80677', 'lng' => (float)'78.13522'];

?>


<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Live Route Tracking</title>
    <style>
        #map {
            height: 100vh;
            width: 100%;
        }

        .top-banner {
            position: absolute;
            top: 10px;
            left: 50%;
            transform: translateX(-50%);
            background: green;
            color: white;
            padding: 10px 20px;
            border-radius: 20px;
            font-size: 18px;
            z-index: 1000;
        }

        .page-center {
            height: calc(100vh - 16px);
            display: flex;
            align-items: center;
            justify-content: center;
        }
    </style>
</head>

<body>

    <?php if ($error): ?>
        <div class="error-message"><?php echo $error; ?></div>
    <?php else: ?>
        <div class="top-banner">Arriving in <span id="arrival-time"></span> minutes</div>
        <div id="map"></div>

        <script>
            let employeeId = "<?php echo isset($employeeId) ? $employeeId : ''; ?>";
            let customerId = "<?php echo isset($customerId) ? $customerId : ''; ?>";
            let workid = "<?php echo isset($workid) ? $workid : ''; ?>";

            let map, directionsService, directionsRenderer, userMarker, startMarker, endMarker;
            let locationUpdateInterval; 
            let startLocation = <?php echo json_encode($startLocation); ?>;
            let endLocation = <?php echo json_encode($endLocation); ?>;

            let looper = 0
            let lastUserLocation = startLocation;
            let routePath = null;
            const deviationThreshold = 200; 
            let isFirstLocationUpdate = true;

            let usercurrentLocation = startLocation;

            async function updateUserLocation(loop) {
                try {
                    let response = await fetch(`https://gpsscheduler.com/app/sandbox/ws/Maidtosparkle/getDummyLocation?loop=${loop}`);
                    let data = await response.json();

                    if (!data.data || !data.data.lat || !data.data.lng || (data.data.lat == 0 && data.data.lng == 0)) {
                        console.warn("Invalid location detected. Hiding map and displaying error message.");
                        document.getElementById("map").style.display = "none";
                        document.querySelector(".top-banner").style.display = "none";
                        document.body.innerHTML += `<div class="error-message"><div class="page-center"><h2>Our crew has arrived at your home!</h2></div></div>`;
                        clearInterval(locationUpdateInterval);
                        return;
                    }

                    if (data.data.lat && data.data.lng) {
                        let userLocation = {
                            lat: parseFloat(data.data.lat), 
                            lng: parseFloat(data.data.lng) 
                        };
                        usercurrentLocation = userLocation;

                        if (userLocation.lat == 0 && userLocation.lng == 0) {
                            console.warn("Invalid location detected (0,0). Stopping tracking.");
                            clearInterval(locationUpdateInterval); 
                            return;
                        }
                                                                                
                        updateArrivalTime(userLocation);

                        directionsService.route(
                            {
                                origin: userLocation,
                                destination: endLocation,
                                travelMode: google.maps.TravelMode.DRIVING
                            },
                            (response, status) => {
                                if (status === google.maps.DirectionsStatus.OK) {
                                    directionsRenderer.setDirections(response);
                                } else {
                                    console.error("Directions request failed due to " + status);
                                }
                            }
                        );

                        if (routePath && isUserOffRoute(userLocation, routePath)) {
                            console.log("User deviated from route, recalculating...");
                            calculateRoute(userLocation);
                        }

                        lastUserLocation = userLocation;
                    } else {
                        console.warn("Invalid location detected (0,0). Stopping tracking.");
                        clearInterval(locationUpdateInterval); // Stop location updates
                        return;
                    }
                } catch (error) {
                    console.error("Error fetching user location:", error);
                }
            }

            function isUserOffRoute(userLocation, routePath) {
                let minDistance = Infinity;

                for (let i = 0; i < routePath.length; i++) {
                    let pathPoint = routePath[i];
                    let distance = google.maps.geometry.spherical.computeDistanceBetween(
                        new google.maps.LatLng(userLocation.lat, userLocation.lng),
                        new google.maps.LatLng(pathPoint.lat(), pathPoint.lng())
                    );

                    if (distance < minDistance) {
                        minDistance = distance;
                    }
                }

                return minDistance > deviationThreshold;
            }

            function updateArrivalTime(userLocation) {
                let service = new google.maps.DistanceMatrixService();
                service.getDistanceMatrix({
                        origins: [userLocation],
                        destinations: [endLocation],
                        travelMode: "DRIVING",
                    },
                    function(response, status) {
                        if (status === "OK") {
                            let duration = response.rows[0].elements[0].duration.value; 
                            let remainingTime = Math.ceil(duration / 60);
                            document.getElementById("arrival-time").innerText = remainingTime;
                        } else {
                            console.error("Error calculating arrival time:", status);
                        }
                    }
                );
            }

            function initMap() {
                map = new google.maps.Map(document.getElementById("map"), {
                    center: startLocation,
                    zoom: 25,
                    disableDefaultUI: true, 
                });

                directionsService = new google.maps.DirectionsService();
                directionsRenderer = new google.maps.DirectionsRenderer({                     
                    polylineOptions: {
                        strokeColor: "#0F53FF", 
                        strokeOpacity: 1.0, 
                        strokeWeight: 10
                    }
                });

                endCircle = new google.maps.Circle({
                    strokeColor: "#0F53FF",
                    strokeOpacity: 1,
                    strokeWeight: 1,
                    fillColor: "#0F53FF",
                    fillOpacity: 1,
                    map: map,
                    center: endLocation,
                    radius: 4 // Adjust to control size (in meters)
                });
                
                map.panTo(endLocation);

                directionsRenderer.setMap(map);
                calculateRoute("DRIVING");
                updateArrivalTime(startLocation);                

                locationUpdateInterval = setInterval(() => {
                    updateUserLocation(looper)
                    ++looper
                }, 1000);                 

                function calculateRoute(travelMode) {
                    let request = {
                        origin: usercurrentLocation,
                        destination: endLocation,
                        travelMode: 'DRIVING',
                    };

                    directionsService.route(request, (result, status) => {
                        if (status === google.maps.DirectionsStatus.OK) {
                            directionsRenderer.setDirections(result);
                        } else {
                            console.error("Error fetching route", status);
                        }
                    });
                }            
                        
            }

            function getDistance(coord1, coord2) {
                let R = 6371;
                let toRad = (deg) => deg * (Math.PI / 180);
                let dLat = toRad(coord2.lat - coord1.lat);
                let dLon = toRad(coord2.lng - coord1.lng);

                let a = Math.sin(dLat / 2) * Math.sin(dLat / 2) +
                    Math.cos(toRad(coord1.lat)) * Math.cos(toRad(coord2.lat)) *
                    Math.sin(dLon / 2) * Math.sin(dLon / 2);
                let c = 2 * Math.atan2(Math.sqrt(a), Math.sqrt(1 - a));
                return R * c * 1000; 
            }


            document.addEventListener("visibilitychange", function() {
                if (document.hidden) {
                    clearInterval(locationUpdateInterval);
                } else {                    
                    locationUpdateInterval = setInterval(updateUserLocation, 4000);
                }
            });
        </script>

        <script type="text/javascript"
            src="https://maps.googleapis.com/maps/api/js?key=AIzaSyBiiThj7Bn5N77CTEmb9Dk_YJOFRvDeLtg&callback=initMap&libraries=places,geometry">
        </script>
    <?php endif; ?>

</body>

</html>