<?php
$workId = $_GET['id'] ?? '';
$teamId = $_GET['team'] ?? '';

if (!$workId || !$teamId) {
    echo "<h3 style='color:red;'>Missing workId or teamId!</h3>";
    exit;
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Real-Time Route View</title>
    <style>
        #map { height: 100vh; width: 100%; }
        .label-box {
            position: absolute;
            top: 10px;
            left: 50%;
            transform: translateX(-50%);
            background: green;
            color: white;
            padding: 6px 16px;
            border-radius: 20px;
            z-index: 999;
        }
    </style>
</head>
<body>

<div class="label-box">Historic Team Route</div>
<div id="map"></div>

<script>
const workId = "<?= $workId ?>";
const teamId = "<?= $teamId ?>";
let map;
const colors = ['red', 'blue', 'green', 'orange', 'purple', 'black'];
let teamRoutes = {}; // To store route polylines for each team member

async function fetchTrackingData() {
    const res = await fetch(`https://gpsscheduler.com/app/sandbox/ws/Maidtosparkle/getViewHistoriclocation?workId=${workId}&teamId=${teamId}`);
    const json = await res.json();
    console.log("Tracking data:", res);

    const customer = json.data.customer;
    const teamTracking = json.data.team_tracking;
    
    if (!map) {
        initMap(customer, teamTracking);
    } else {
        updateRoutes(customer, teamTracking);
    }
}

function initMap(customer, teamTracking) {
    // map = new google.maps.Map(document.getElementById("map"), {
    //     center: customer,
    //     zoom: 2,
    //     mapTypeControl: false,
    // });
    
    map = new google.maps.Map(document.getElementById("map"), {
        mapTypeControl: true, // Enable satellite/roadmap toggle
        zoomControl: true,   // Enable zoom in/out buttons
        scaleControl: true,  // Show scale
        streetViewControl: true, // Enable Street View
        fullscreenControl: true, // Enable fullscreen mode
        mapTypeControlOptions: {
            style: google.maps.MapTypeControlStyle.DROPDOWN_MENU, // Dropdown for map types
            mapTypeIds: [
                google.maps.MapTypeId.ROADMAP,
                google.maps.MapTypeId.SATELLITE,
                google.maps.MapTypeId.HYBRID,
                google.maps.MapTypeId.TERRAIN
            ]
        }
    });
    
    const bounds = new google.maps.LatLngBounds();
    
    // Add customer location to bounds
    bounds.extend(customer);

    // Customer Marker (Destination)
    new google.maps.Marker({
        position: customer,
        map,
        title: customer.name || 'Customer Location',
        icon: 'http://maps.google.com/mapfiles/ms/icons/red-dot.png',
        label: {
            text: 'C',
            color: 'white',
            fontWeight: 'bold'
        }
    });

    // Process each team member's tracking data
    teamTracking.forEach((member, i) => {
        const color = colors[i % colors.length];
        const trackingPoints = member.tracking_data || [];
        
        if (trackingPoints.length === 0) return;
        
        trackingPoints.forEach(point => {
            bounds.extend(point);
        });
        
        // Get first point (start) and last point (most recent)
        const startPoint = trackingPoints[0];
        const latestPoint = trackingPoints[trackingPoints.length - 1];
        
        // Team Member Marker (current position)
        new google.maps.Marker({
            position: startPoint,
            map,
            title: member.name || 'Team Member',
            icon: `http://maps.google.com/mapfiles/ms/icons/${color}-dot.png`,
            label: {
                text: String.fromCharCode(65 + i), // A, B, C, etc.
                color: 'white',
                fontWeight: 'bold'
            }
        });
        
        const trackingPointsS = member.tracking_data || [];

const offsetPoints = i === 0 ? trackingPointsS : offsetPath(trackingPointsS);
        
        // Draw the actual traveled path
        const path = new google.maps.Polyline({
            path: offsetPoints,
            geodesic: true,
            strokeColor: color,
            strokeOpacity: 0.6,
            strokeWeight: 5,
            map: map
        });
        
        // Store the path for updates
        teamRoutes[member.userId] = path;
        
        // Draw route from current position to customer
        const service = new google.maps.DirectionsService();
        service.route({
            origin: latestPoint,
            destination: customer,
            travelMode: google.maps.TravelMode.DRIVING
        }, (result, status) => {
            if (status === 'OK') {
                new google.maps.DirectionsRenderer({
                    map,
                    directions: result,
                    suppressMarkers: true,
                    polylineOptions: {
                        strokeColor: color,
                        strokeOpacity: 0.6,
                        strokeWeight: 5
                    }
                });
            }
        });
    });
    
    if (!bounds.isEmpty()) {
        map.fitBounds(bounds);
        
        // Optional: Set a minimum zoom level to avoid zooming in too much
        google.maps.event.addListenerOnce(map, 'bounds_changed', function() {
            if (map.getZoom() > 15) {
                map.setZoom(15);
            }
        });
    }
}

function offsetPath(points, offset = 0.00002) {
    return points.map(p => ({
        lat: p.lat + offset,
        lng: p.lng + offset
    }));
}

function updateRoutes(customer, teamTracking) {
    teamTracking.forEach((member, i) => {
        const color = colors[i % colors.length];
        const trackingPoints = member.tracking_data || [];
        
        if (trackingPoints.length === 0) return;
        
        const latestPoint = trackingPoints[trackingPoints.length - 1];
        
        // Update existing path or create new one
        if (teamRoutes[member.userId]) {
            teamRoutes[member.userId].setPath(trackingPoints);
        } else {
            teamRoutes[member.userId] = new google.maps.Polyline({
                path: trackingPoints,
                geodesic: true,
                strokeColor: color,
                strokeOpacity: 0.6,
                strokeWeight: 5,
                map: map
            });
        }
        
        // Update route from current position to customer
        const service = new google.maps.DirectionsService();
        service.route({
            origin: latestPoint,
            destination: customer,
            travelMode: google.maps.TravelMode.DRIVING
        }, (result, status) => {
            if (status === 'OK') {
                // Clear previous direction renderers for this member
                // In a real app, you might want to store and remove previous renderers
                new google.maps.DirectionsRenderer({
                    map,
                    directions: result,
                    suppressMarkers: true,
                    polylineOptions: {
                        strokeColor: color,
                        strokeOpacity: 0.6,
                        strokeWeight: 5
                    }
                });
            }
        });
    });
}

fetchTrackingData();
// setInterval(fetchTrackingData, 10000);
</script>

<script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyBQq4uDlt2QmhqCZzXNS5T6fBmM-zjrmKU&libraries=places,geometry"></script>
</body>
</html>