<?php
$workId = $_GET['id'] ?? '';
$teamId = $_GET['team'] ?? '';

if (!$workId || !$teamId) {
    echo "<h3 style='color:red;'>Missing workId or teamId!</h3>";
    exit;
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Real-Time Route View</title>
    <style>
        #map { height: 100vh; width: 100%; }
        .label-box {
            position: absolute;
            top: 10px;
            left: 50%;
            transform: translateX(-50%);
            background: green;
            color: white;
            padding: 6px 16px;
            border-radius: 20px;
            z-index: 999;
        }
    </style>
</head>
<body>

<div class="label-box">Live Team Route to Customer</div>
<div id="map"></div>

<script>
const workId = "<?= $workId ?>";
const teamId = "<?= $teamId ?>";
let map;
const colors = ['red', 'blue', 'green', 'orange', 'purple', 'black'];

// Store references for reuse
let customerMarker;
let teamMarkers = {};
let teamRenderers = {};

async function fetchTrackingData() {
    try {
        const res = await fetch(`https://gpsscheduler.com/app/sandbox/ws/Maidtosparkle/getViewRealtimelocation?workId=${workId}&teamId=${teamId}`);
        const json = await res.json();

        const customer = json.data.customer;
        const team = json.data.teamMembers;

        if (!map) {
            initMap(customer, team);
        } else {
            updateMap(customer, team);
        }
    } catch (err) {
        console.error("Fetch error:", err);
    }
}

function initMap(customer, teamMembers) {
    map = new google.maps.Map(document.getElementById("map"), {
        center: customer,
        zoom: 13,
        mapTypeControl: true,
        mapTypeControlOptions: {
            style: google.maps.MapTypeControlStyle.DROPDOWN_MENU,
            position: google.maps.ControlPosition.TOP_RIGHT,
            mapTypeIds: [
                google.maps.MapTypeId.ROADMAP,
                google.maps.MapTypeId.SATELLITE,
                google.maps.MapTypeId.HYBRID,
                google.maps.MapTypeId.TERRAIN
            ]
        },
        streetViewControl: true,
        fullscreenControl: true 
    });

    // Customer Marker
    customerMarker = new google.maps.Marker({
        position: customer,
        map,
        title: customer.name,
        icon: 'http://maps.google.com/mapfiles/ms/icons/red-dot.png',
        label: { text: 'E', color: 'white', fontWeight: 'bold' }
    });

    teamMembers.forEach((member, i) => {
        const color = colors[i % colors.length];

        // Team Marker
        const marker = new google.maps.Marker({
            position: { lat: member.lat, lng: member.lng },
            map,
            title: member.name,
            icon: `http://maps.google.com/mapfiles/ms/icons/${color}-dot.png`,
            label: { text: 'S', color: 'white', fontWeight: 'bold' }
        });

        // Renderer for route
        const renderer = new google.maps.DirectionsRenderer({
            map,
            suppressMarkers: true,
            polylineOptions: { strokeColor: color, strokeWeight: 7 }
        });

        teamMarkers[member.id] = marker;
        teamRenderers[member.id] = renderer;

        drawRoute(member, customer, renderer);
    });
}

function updateMap(customer, teamMembers) {
    // Update customer location (if needed)
    customerMarker.setPosition(customer);

    teamMembers.forEach((member, i) => {
        const marker = teamMarkers[member.id];
        const renderer = teamRenderers[member.id];

        if (marker) {
            // Update position
            marker.setPosition({ lat: member.lat, lng: member.lng });
            // Update route
            drawRoute(member, customer, renderer);
        } else {
            // New team member (not in map yet)
            const color = colors[i % colors.length];
            const newMarker = new google.maps.Marker({
                position: { lat: member.lat, lng: member.lng },
                map,
                title: member.name,
                icon: `http://maps.google.com/mapfiles/ms/icons/${color}-dot.png`,
                label: { text: 'S', color: 'white', fontWeight: 'bold' }
            });

            const newRenderer = new google.maps.DirectionsRenderer({
                map,
                suppressMarkers: true,
                polylineOptions: { strokeColor: color, strokeWeight: 7 }
            });

            teamMarkers[member.id] = newMarker;
            teamRenderers[member.id] = newRenderer;

            drawRoute(member, customer, newRenderer);
        }
    });
}

function drawRoute(member, customer, renderer) {
    const service = new google.maps.DirectionsService();
    service.route({
        origin: { lat: member.lat, lng: member.lng },
        destination: customer,
        travelMode: google.maps.TravelMode.DRIVING
    }, (result, status) => {
        if (status === 'OK') {
            renderer.setDirections(result);
        } else {
            console.error("Route failed for " + member.name, status);
        }
    });
}

// Fetch first time
fetchTrackingData();

// Refresh every 10 seconds (adjust as needed)
setInterval(fetchTrackingData, 2000);
</script>


<script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyBQq4uDlt2QmhqCZzXNS5T6fBmM-zjrmKU&libraries=places,geometry"></script>
</body>
</html>
