<?php

if (!defined('BASEPATH'))
{
    exit('No direct script access allowed');
}

if (!function_exists('pre'))
{

    function pre($data)
    {
        echo "<pre>";
        print_r($data);
        echo "</pre>";
        exit;
    }

}

if (!function_exists('pr'))
{

    function pr($data)
    {
        echo "<pre>";
        print_r($data);
        echo "</pre>";
    }

}

if (!function_exists('_j'))
{

    function _j($data)
    {
        if (is_array($data))
        {
            echo json_encode($data);
        } else
        {
            echo json_encode(array($data));
        }
    }

}

if (!function_exists('je'))
{

    function je($data)
    {
        if (is_array($data))
        {
            echo json_encode($data);
        } else
        {
            echo json_encode(array($data));
        }

        exit;
    }

}

if (!function_exists('je_mobile'))
{

    function je_mobile($Status, $Message = "", $ResponseData, $extraData)
    {
        $ignoreData = array('401');
        $ResponseData = (isset($ResponseData)) ? $ResponseData : new stdClass();
        $extraData = (isset($extraData)) ? $extraData : new stdClass();
        if (is_array($ResponseData))
        {
            $data["status"] = $Status;
            $data["data"] = $ResponseData;
            if (!empty($extraData))
            {
                foreach ($extraData as $key => $val)
                {
                    $data[$key] = $val;
                }
            }
            $data["message"] = $Message;
        } else
        {
            $data["status"] = $Status;
            $data["data"] = $ResponseData;
            $data["message"] = $Message;
        }
        je($data);
    }

}

if (!function_exists('compulsoryAlphaNumeric'))
{

    function compulsoryAlphaNumeric($my_str)
    {

        $alpha_okay = FALSE;
        $num_okay = FALSE;
        $string_okay = TRUE;

        $without_alpha = str_replace(
                array_merge(
                        range("a", "z"), range("A", "Z")
                ), '', strtolower($my_str)
        );

        if (strlen($my_str) > strlen($without_alpha))
        {
            $alpha_okay = true;
        }

        $without_num = str_replace(range(0, 9), '', $without_alpha);

        if (strlen($without_alpha) > strlen($without_num))
        {
            $num_okay = true;
        }

        if (strlen($without_num) > 0)
        {
            $string_okay = false;
        }

        if (!($alpha_okay))
        {
            return 'noalpha';
        } else if (!($num_okay))
        {
            return 'nonum';
        } else if ($string_okay == false)
        {
            return 'specialchar';
        } else
        {
            return TRUE;
        }
    }

}

if (!function_exists('Xauto_link'))
{

    /**
     * Replace links in text with html links
     *
     * @param  string $text
     * @return string
     */
    function Xauto_link($str, $attributes = array())
    {
        $attrs = '';
        foreach ($attributes as $attribute => $value)
        {
            $attrs .= " {$attribute}=\"{$value}\"";
        }
        $str = ' ' . $str;
        $str = preg_replace(
                '`([^"=\'>])(((http|https|ftp)://|www.)[^\s<]+[^\s<\.)])`i', '$1<a href="$2"' . $attrs . ' target="_blank">$2</a>', $str
        );
        $str = substr($str, 1);
        $str = preg_replace('`href=\"www`', 'href="http://www', $str);
// f端gt http:// hinzu, wenn nicht vorhanden
        return $str;
    }

}
if (!function_exists('check_url'))
{

    function check_url($url)
    {
        if (preg_match("/^.*((youtu.be\/)|(v\/)|(\/u\/\w\/)|(embed\/)|(watch\?))\??v?=?([^#\&\?]*).*/", $url, $matches))
        {
            return 'youtube';
        } else if (preg_match("/^.*(vimeo\.com\/)((channels\/[A-z]+\/)|(groups\/[A-z]+\/videos\/))?([0-9]+)/", $url, $matches))
        {
            return 'vimeo';
        } else if (preg_match("/^.+dailymotion.com\/(video|hub)\/([^_]+)[^#]*(#video=([^_&]+))?/", $url, $matches))
        {
            return 'dailymotion';
        } else if (preg_match("/^.*(metacafe\.com)(\/watch\/)(\d+)(.*)/i", $url, $matches))
        {
            return 'metacafe';
        } else
        {
            return false;
        }
    }

}

if (!function_exists('generate_token'))
{

    function generate_token($len = 32)
    {

// Array of potential characters, shuffled.
        $chars = array(
            'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm',
            'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z',
            'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M',
            'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z',
            '0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
        );
        shuffle($chars);

        $num_chars = count($chars) - 1;
        $token = '';

// Create random token at the specified length.
        for ($i = 0; $i < $len; $i++)
        {
            $token .= $chars[mt_rand(0, $num_chars)];
        }

        return $token;
    }

}

if (!function_exists('getOS'))
{

    function getOS($user_agent)
    {

        global $user_agent;

        $os_platform = "Unknown OS Platform";

        $os_array = array(
            '/windows nt 6.3/i' => 'Windows 8.1',
            '/windows nt 6.2/i' => 'Windows 8',
            '/windows nt 6.1/i' => 'Windows 7',
            '/windows nt 6.0/i' => 'Windows Vista',
            '/windows nt 5.2/i' => 'Windows Server 2003/XP x64',
            '/windows nt 5.1/i' => 'Windows XP',
            '/windows xp/i' => 'Windows XP',
            '/windows nt 5.0/i' => 'Windows 2000',
            '/windows me/i' => 'Windows ME',
            '/win98/i' => 'Windows 98',
            '/win95/i' => 'Windows 95',
            '/win16/i' => 'Windows 3.11',
            '/macintosh|mac os x/i' => 'Mac OS X',
            '/mac_powerpc/i' => 'Mac OS 9',
            '/linux/i' => 'Linux',
            '/ubuntu/i' => 'Ubuntu',
            '/iphone/i' => 'iPhone',
            '/ipod/i' => 'iPod',
            '/ipad/i' => 'iPad',
            '/android/i' => 'Android',
            '/blackberry/i' => 'BlackBerry',
            '/webos/i' => 'Mobile',
        );

        foreach ($os_array as $regex => $value)
        {

            if (preg_match($regex, $user_agent))
            {
                $os_platform = $value;
            }
        }

        return $os_platform;
    }

}

if (!function_exists('getBrowser'))
{

    function getBrowser($user_agent)
    {

        global $user_agent;

        $browser = "Unknown Browser";

        $browser_array = array(
            '/msie/i' => 'Internet Explorer',
            '/firefox/i' => 'Firefox',
            '/safari/i' => 'Safari',
            '/chrome/i' => 'Chrome',
            '/opera/i' => 'Opera',
            '/netscape/i' => 'Netscape',
            '/maxthon/i' => 'Maxthon',
            '/konqueror/i' => 'Konqueror',
            '/mobile/i' => 'Handheld Browser',
        );

        foreach ($browser_array as $regex => $value)
        {

            if (preg_match($regex, $user_agent))
            {
                $browser = $value;
            }
        }

        return $browser;
    }

}

if (!function_exists('getIP'))
{

    function getIP()
    {

        if (!empty($_SERVER['HTTP_CLIENT_IP']))
        {
            $ip = $_SERVER['HTTP_CLIENT_IP'];
        } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR']))
        {
            $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
        } else
        {
            $ip = $_SERVER['REMOTE_ADDR'];
        }
        return $ip;
    }

}

/**
 * Returns base64 encoded string prepended by "data:image/"
 *
 * @param $filename string
 * @param $filetype string
 * @return string
 */
if (!function_exists('base64_encode_image'))
{

    function base64_encode_image($filename, $filetype = "jpg")
    {
        if ($filename)
        {
            $imgbinary = fread(fopen($filename, "r"), filesize($filename));
            return 'data:image/' . $filetype
                    . ';base64,' . base64_encode($imgbinary);
        }
    }

}
if (!function_exists('text_to_img'))
{

    function text_to_img($text)
    {

        $smileys = array
            (
            '(angry)' => 'image_1',
            ':longface:' => 'image_2',
            ':bigsurprise:' => 'image_3',
            ':smirk:' => 'image_4',
        );

        $smile = $text;

        foreach ($smileys as $key => $value)
        {
            if (strpos($text, $key) !== FALSE)
            {
                $smile = str_replace($key, '<img src="' . FRONT_IMAGE_URL . 'smileys/' . $value . '.gif">', $smile);
            }
        }
        return $smile;
    }

}

if (!function_exists('removeElementWithValue'))
{

    function removeElementWithValue($array, $key, $value)
    {
        foreach ($array as $subKey => $subArray)
        {
            if ($subArray[$key] == $value)
            {
                unset($array[$subKey]);
            }
        }
        return $array;
    }

}
if (!function_exists('removeObjectElementWithValue'))
{

    function removeObjectElementWithValue($array, $key, $value)
    {
        foreach ($array as $subKey => $subArray)
        {
            if ($subArray->$key == $value)
            {
                unset($array[$subKey]);
            }
        }
        return $array;
    }

}
if (!function_exists('extract_email_address'))
{

    function extract_email_address($string)
    {
        preg_match('/\<(.*)\>/', $string, $matches);
        if (!empty($matches) && isset($matches[1]))
        {
            return $matches[1];
        } else
        {
            return $string;
        }
    }

}

if (!function_exists('array_column'))
{

    /**
     * Returns the values from a single column of the input array, identified by
     * the $columnKey.
     *
     * Optionally, you may provide an $indexKey to index the values in the returned
     * array by the values from the $indexKey column in the input array.
     *
     * @param array $input A multi-dimensional array (record set) from which to pull
     * a column of values.
     * @param mixed $columnKey The column of values to return. This value may be the
     * integer key of the column you wish to retrieve, or it
     * may be the string key name for an associative array.
     * @param mixed $indexKey (Optional.) The column to use as the index/keys for
     * the returned array. This value may be the integer key
     * of the column, or it may be the string key name.
     * @return array
     */
    function array_column($input = null, $columnKey = null, $indexKey = null)
    {

// Using func_get_args() in order to check for proper number of
// parameters and trigger errors exactly as the built-in array_column()
// does in PHP 5.5.
        $argc = func_num_args();
        $params = func_get_args();
        if ($argc < 2)
        {
            trigger_error("array_column() expects at least 2 parameters, {$argc} given", E_USER_WARNING);
            return null;
        }
        if (!is_array($params[0]))
        {
            trigger_error('array_column() expects parameter 1 to be array, ' . gettype($params[0]) . ' given', E_USER_WARNING);
            return null;
        }
        if (!is_int($params[1]) && !is_float($params[1]) && !is_string($params[1]) && $params[1] !== null && !(is_object($params[1]) && method_exists($params[1], '__toString'))
        )
        {
            trigger_error('array_column(): The column key should be either a string or an integer', E_USER_WARNING);
            return false;
        }
        if (isset($params[2]) && !is_int($params[2]) && !is_float($params[2]) && !is_string($params[2]) && !(is_object($params[2]) && method_exists($params[2], '__toString'))
        )
        {
            trigger_error('array_column(): The index key should be either a string or an integer', E_USER_WARNING);
            return false;
        }
        $paramsInput = $params[0];
        $paramsColumnKey = ($params[1] !== null) ? (string) $params[1] : null;
        $paramsIndexKey = null;
        if (isset($params[2]))
        {
            if (is_float($params[2]) || is_int($params[2]))
            {
                $paramsIndexKey = (int) $params[2];
            } else
            {
                $paramsIndexKey = (string) $params[2];
            }
        }
        $resultArray = array();
        foreach ($paramsInput as $row)
        {
            $key = $value = null;
            $keySet = $valueSet = false;
            if ($paramsIndexKey !== null && array_key_exists($paramsIndexKey, $row))
            {
                $keySet = true;
                $key = (string) $row[$paramsIndexKey];
            }
            if ($paramsColumnKey === null)
            {
                $valueSet = true;
                $value = $row;
            } elseif (is_array($row) && array_key_exists($paramsColumnKey, $row))
            {
                $valueSet = true;
                $value = $row[$paramsColumnKey];
            }
            if ($valueSet)
            {
                if ($keySet)
                {
                    $resultArray[$key] = $value;
                } else
                {
                    $resultArray[] = $value;
                }
            }
        }
        return $resultArray;
    }

}
if (!function_exists('date_compare'))
{

    function date_compare($a, $b)
    {
        $t1 = strtotime($a['dCreatedDate']);
        $t2 = strtotime($b['dCreatedDate']);
        return $t1 - $t2;
    }

}
if (!function_exists('getDates'))
{

    function getDates($startTime, $endTime)
    {
        $day = 86400;
        $format = 'Y-m-d';
        $startTime = strtotime($startTime);
        $endTime = strtotime($endTime);
//$numDays = round(($endTime - $startTime) / $day) + 1;
        $numDays = round(($endTime - $startTime) / $day); // remove increment

        $days = array();

        for ($i = 1; $i < $numDays; $i++)
        {
//change $i to 1
            $days[] = date($format, ($startTime + ($i * $day)));
        }

        return $days;
    }

}
if (!function_exists('time_elapsed_string'))
{

    function time_elapsed_string($ptime)
    {
//        echo  time();
        $etime = time() - $ptime;

        if ($etime < 1)
        {
            return '0 seconds';
        }

        $a = array(365 * 24 * 60 * 60 => 'year',
            30 * 24 * 60 * 60 => 'month',
            24 * 60 * 60 => 'day',
            60 * 60 => 'hour',
            60 => 'minute',
            1 => 'second',
        );
        $a_plural = array('year' => 'years',
            'month' => 'months',
            'day' => 'days',
            'hour' => 'hours',
            'minute' => 'minutes',
            'second' => 'seconds',
        );

        foreach ($a as $secs => $str)
        {
            $d = $etime / $secs;
            if ($d >= 1)
            {
                $r = round($d);
                return $r . ' ' . ($r > 1 ? $a_plural[$str] : $str) . ' ago';
            }
        }
    }

}

function createDateRangeArray($strDateFrom, $strDateTo)
{
// takes two dates formatted as YYYY-MM-DD and creates an
// inclusive array of the dates between the from and to dates.
// could test validity of dates here but I'm already doing
// that in the main script

    $aryRange = array();

    $iDateFrom = mktime(1, 0, 0, substr($strDateFrom, 5, 2), substr($strDateFrom, 8, 2), substr($strDateFrom, 0, 4));
    $iDateTo = mktime(1, 0, 0, substr($strDateTo, 5, 2), substr($strDateTo, 8, 2), substr($strDateTo, 0, 4));

    if ($iDateTo >= $iDateFrom)
    {
        array_push($aryRange, date('Y-m-d', $iDateFrom)); // first entry
        while ($iDateFrom < $iDateTo)
        {
            $iDateFrom += 86400; // add 24 hours
            array_push($aryRange, date('Y-m-d', $iDateFrom));
        }
    }
    return $aryRange;
}

if (!function_exists('generate_password'))
{

    function generate_password($chars_min = 6, $chars_max = 8, $use_upper_case = false, $include_numbers = false, $include_special_chars = false)
    {
        $length = rand($chars_min, $chars_max);
        $selection = 'aeuoyibcdfghjklmnpqrstvwxz';
        if ($include_numbers)
        {
            $selection .= "1234567890";
        }
        if ($include_special_chars)
        {
            $selection .= "!@\"#$%&[]{}?|";
        }

        $password = "";
        for ($i = 0; $i < $length; $i++)
        {
            $current_letter = $use_upper_case ? (rand(0, 1) ? strtoupper($selection[(rand() % strlen($selection))]) : $selection[(rand() % strlen($selection))]) : $selection[(rand() % strlen($selection))];
            $password .= $current_letter;
        }

        return $password;
    }

}

function uploadImageFromURL($URL, $uploadPath, $uploadThumbPath = "", $thumbArray = array(), $oldFileName = "")
{
//echo $URL;
//echo "<br>";
    $ch = curl_init();
    $timeout = 5;
    curl_setopt($ch, CURLOPT_URL, $URL);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, $timeout);
    $data = curl_exec($ch);
    curl_close($ch);
    $decodeCoverData = json_decode($data);

    if (!empty($decodeCoverData->cover->id))
    {
        $URL = $decodeCoverData->cover->source;
    }

    $fileName = md5(time() . rand()) . '.jpg';
    /* Path to the location to save the image on your server */
    $img_save_location = $uploadPath . $fileName;

    /* Use file_put_contents to get and save image */
    file_put_contents($img_save_location, file_get_contents($URL));
//echo "<br>".$fileName;
    return $fileName;
}

/* -------------------------------------------------+
  | Gets Image Raw Data,
  | Used with GD Lib (imagecreatefromstring)
  +------------------------------------------------- */

function getImageRawData($image_url)
{
    if (function_exists('curl_init'))
    {
        $opts = array();
        $http_headers = array();
        $http_headers[] = 'Expect:';

        $opts[CURLOPT_URL] = $image_url;
        $opts[CURLOPT_HTTPHEADER] = $http_headers;
        $opts[CURLOPT_CONNECTTIMEOUT] = 10;
        $opts[CURLOPT_TIMEOUT] = 60;
        $opts[CURLOPT_HEADER] = FALSE;
        $opts[CURLOPT_BINARYTRANSFER] = TRUE;
        $opts[CURLOPT_VERBOSE] = FALSE;
        $opts[CURLOPT_SSL_VERIFYPEER] = FALSE;
        $opts[CURLOPT_SSL_VERIFYHOST] = 2;
        $opts[CURLOPT_RETURNTRANSFER] = TRUE;
        $opts[CURLOPT_FOLLOWLOCATION] = TRUE;
        $opts[CURLOPT_MAXREDIRS] = 2;
        $opts[CURLOPT_IPRESOLVE] = CURL_IPRESOLVE_V4;

# Initialize PHP/CURL handle
        $ch = curl_init();
        curl_setopt_array($ch, $opts);
        $content = curl_exec($ch);

# Close PHP/CURL handle
        curl_close($ch);
    }// use file_get_contents
    elseif (ini_get('allow_url_fopen'))
    {
        $content = file_get_contents($image_url);
    }

# Return results
    return $content;
}

if (!function_exists('isJson'))
{

    function isJson($string)
    {
        json_decode($string);
        return (json_last_error() == JSON_ERROR_NONE);
    }

}
if (!function_exists('getTableValue'))
{

    function getTableValue($table = '', $column = '', $where = array())
    {
        $CI = &get_instance();
        $CI->db->select($column);
        $qry = $CI->db->get_where($table, $where);
        if ($qry->num_rows() > 0)
        {
            $qry = $qry->row();
            return $qry->$column;
        } else
        {
            return '';
        }
    }

}
if (!function_exists('expires_in'))
{

    function expires_in($expiry, $timeZone)
    {

        $now = new DateTime(gmdate('Y-m-d H:i:s'));
        $expiry_date = new DateTime($expiry);

        $now->setTimeZone(new DateTimeZone($timeZone));
        $expiry_date->setTimeZone(new DateTimeZone($timeZone));
        $interval = $expiry_date->diff($now);

        $days = $interval->format("%a");
        $hours = $interval->format("%h");
        $minutes = $interval->format("%i");
        $seconds = $interval->format("%s");

        $dayStr = ($days > 1 ? ' days ' : ' day ') . ($hours > 0 || $minutes > 0 ? ', ' : '');
        $hourStr = ($hours > 1 ? ' hours ' : ' hour ') . ($minutes > 0 || $seconds > 0 ? ', ' : '');
        $minuteStr = ($minutes > 1 ? ' minutes ' : ' minute ') . ($seconds > 0 ? ', ' : '');
        $secondStr = ($seconds > 1 ? ' seconds ' : ' second ');

//If days found 
        if ($days > 0 && $hours > 0)
        {
            $strExpires = $days . $dayStr . $hours . $hourStr; //Days + Hours
        } elseif ($days == 0 && $hours > 0 && $minutes > 0)
        {
            $strExpires = $hours . $hourStr . $minutes . $minuteStr; //Hours + Minutes
        } elseif ($minutes >= 0 && $seconds > 0)
        {
            $strExpires = $minutes . $minuteStr . $seconds . $secondStr; // Minutes + Seconds
        } elseif ($seconds >= 0)
        {
            $strExpires = $seconds . $secondStr;
        }

//        $strExpires = ($days > 0 ? $days . $dayStr : '') . ($hours > 0 ? $hours . $hourStr : '') . ($minutes > 0 ? $minutes . $minuteStr : '') . ($seconds > 0 ? $seconds . $secondStr : '');
//        pre($interval);

        /* $interval->format("%a days, %h hours, %i minutes, %s seconds"); */
        return trim(trim($strExpires), ",");
    }

}
if (!function_exists('getImage'))
{

    function getImage($iThumbId = 0, $filepath = "", $zc = 0, $ql = 100)
    {
        $CI = &get_instance();
        $src = FRONT_IMAGE_PATH . "no_image_available.png";
        $params = array();

        $cords = $CI->db->get_where('mst_imagethumb', array('iThumbId' => $iThumbId));

        if ($cords->num_rows() > 0)
        {
            $res = $cords->row_array();
            $file = $res['vFolder'] . '/' . $filepath;
            $filepath = UPLOAD_URL . $file;

            if (!is_file(UPLOAD_PATH . $file))
            {
                if ($res['vDefaultImage'] != '')
                {
                    $filepath = UPLOAD_URL . $res['vFolder'] . '/' . $res['vDefaultImage'];
                } else
                {
                    $filepath = $src;
                }
            }
            $src = $filepath;
            $src = site_url("application/libraries/timthumb.php?w=" . $res['iWidth'] . "&h=" . $res['iHeight'] . "&zc=" . $zc . "&q=" . $ql . "&a=c&src=" . $src);
        }
        return $src;
    }

}
if (!function_exists('disMessage'))
{

    /**
     * Random Element - Takes an array as input and returns a random element
     *
     * @param	array
     * @return	mixed	depends on what the array contains
     */
    function disMessage($msgArray = array(), $script = true)
    {
        $CI = &get_instance();
        $message = '';
        $content = '';
        $type = isset($msgArray["type"]) ? $msgArray["type"] : NULL;
        $var = isset($msgArray["var"]) ? $msgArray["var"] : NULL;
        $CI->session->unset_userdata('msgType');
        if (!is_null($var))
        {
            if (defined($var))
            {
                $message = constant($var);
            } else
            {
                $message = $var;
            }
        }

        if ($script)
        {
            $content = '<script type="text/javascript" language="javascript">$(document).ready(function(){Custom.myNotification("' . ucwords($type) . '","' . $message . '");})</script>';
        } else
        {
            $content = $message;
        }

        return $content;
    }

}
if (!function_exists('time_ago'))
{

    function time_ago($ptime)
    {

        $time = strtotime($ptime);
        $periods = array("second", "minute", "hour", "day", "week", "month", "year", "decade");
        $lengths = array("60", "60", "24", "7", "4.35", "12", "10");

//$now = time();
        $now = strtotime(date('Y-m-d H:i:s'));
        $difference = $now - $time;
        $tense = "ago";

        for ($j = 0; $difference >= $lengths[$j] && $j < count($lengths) - 1; $j++)
        {
            $difference /= $lengths[$j];
        }
        $difference = round($difference);
        if ($difference != 1)
        {
            $periods[$j] .= "s";
        }
        $timeAgoText = (($difference < 0) ? "Just Now" : $difference . " " . $periods[$j] . " " . "ago" );
        return $timeAgoText;
    }

}
if (!function_exists('mb_truncate'))
{

    function mb_truncate($str, $limit)
    {
        return mb_substr(strip_tags($str), 0, $limit, 'UTF-8') . (mb_strlen($str) > $limit ? '...' : '');
    }

}

function convertFromUTC($dateTime = '', $timeZone = '', $format = 'Y-m-d H:i:s')
{
// create DateTime object
    $d = DateTime::createFromFormat($format, $dateTime, new DateTimeZone('UTC'));
// convert timezone
    $d->setTimeZone(new DateTimeZone($timeZone));
// convert dateformat
    return $d->format($format);
}

function convertToUTC($dateTime = '', $timeZone = '', $format = 'Y-m-d H:i:s')
{
// create DateTime object
    $d = DateTime::createFromFormat($format, $dateTime, new DateTimeZone($timeZone));
// convert timezone
    $d->setTimeZone(new DateTimeZone('UTC'));
// convert dateformat
    return $d->format($format);
}

function __autoController($classname)
{

    if (strpos($classname, 'CI_') !== 0)
    {
        $file = APPPATH . 'controller/ws/' . $classname . '.php';
        if (file_exists($file) && is_file($file))
        {
            @include_once($file);
        }
    }
}

function _EmailMobileNumberRegex($vEmailOrMobileNumber)
{
    if (( 1 !== preg_match('/^\d{10}$/', $vEmailOrMobileNumber) ) || ( 1 !== preg_match('/^([a-z A-Z 0-9 _\.\-])+\@(([a-z A-Z 0-9\-])+\.)+([a-z A-z 0-9]{3,3})+$/', $vEmailOrMobileNumber) ))
    {
        return FALSE;
    } else
    {
        return TRUE;
    }
}

function distance($lat1, $lon1, $lat2, $lon2, $unit)
{
    $theta = $lon1 - $lon2;
    $dist = sin(deg2rad($lat1)) * sin(deg2rad($lat2)) + cos(deg2rad($lat1)) * cos(deg2rad($lat2)) * cos(deg2rad($theta));
    $dist = acos($dist);
    $dist = rad2deg($dist);
    $miles = $dist * 60 * 1.1515;
    $unit = strtoupper($unit);

    if ($unit == "K")
    {
        return ($miles * 1.609344);
    } else if ($unit == "N")
    {
        return ($miles * 0.8684);
    } else
    {
        return $miles;
    }
}

function safe_b64encode($string)
{
    $data = base64_encode($string);
    $data = str_replace(array('+', '/', '='), array('-', '_', ''), $data);
    return $data;
}

function safe_b64decode($string)
{
    $data = str_replace(array('-', '_'), array('+', '/'), $string);
    $mod4 = strlen($data) % 4;
    if ($mod4)
    {
        $data .= substr('====', $mod4);
    }
    return base64_decode($data);
}

function encode($value)
{
    if (!$value && $value != 0)
    {
        return false;
    }
    $text = $value;
    $iv_size = mcrypt_get_iv_size(MCRYPT_RIJNDAEL_256, MCRYPT_MODE_ECB);
    $iv = mcrypt_create_iv($iv_size, MCRYPT_RAND);
    $crypttext = mcrypt_encrypt(MCRYPT_RIJNDAEL_256, ENC_PRIVATE_KEY, $text, MCRYPT_MODE_ECB, $iv);
    return trim(safe_b64encode($crypttext));
}

function decode($value)
{
    if (!$value)
    {
        return false;
    }
    $crypttext = safe_b64decode($value);
    $iv_size = mcrypt_get_iv_size(MCRYPT_RIJNDAEL_256, MCRYPT_MODE_ECB);
    $iv = mcrypt_create_iv($iv_size, MCRYPT_RAND);
    $decrypttext = mcrypt_decrypt(MCRYPT_RIJNDAEL_256, ENC_PRIVATE_KEY, $crypttext, MCRYPT_MODE_ECB, $iv);
    return trim($decrypttext);
}

/* Explorernd of file programmer_helper.php */
/* Location: ./system/helpers/programmer_helper.php */