<?php
// auto_payroll_processor.php
// This file is executed by cron job for true automation


// Log all output to file
ob_start();

function log_message2($message) {
    $timestamp = date('Y-m-d H:i:s');
    $log_entry = "[$timestamp] $message\n";
    echo $log_entry;
    error_log($message, 3, __DIR__ . '/payroll_automation.log');
}

log_message2("=== Starting Automatic Payroll Processor ===");

// Include required files
require_once 'db.php';
require_once 'gusto_api.php';
ini_set('display_errors', '1');
ini_set('display_startup_errors', '1');
error_reporting(E_ALL);
try {
    $config = require __DIR__ . '/gusto_config.php';
    log_message2("✓ Configuration loaded");
} catch (Exception $e) {
    log_message2("✗ Failed to load configuration: " . $e->getMessage());
    exit(1);
}

// Check database connection
if (!$con) {
    log_message2("✗ Database connection failed");
    exit(1);
}

log_message2("✓ Database connected successfully");

/**
 * Execute automatic payroll processing
 */
function executeAutomaticPayroll($con, $config) {
    log_message2("Starting automatic payroll execution...");
    
    // Get the current week's Monday
    $current_week_start = date('Y-m-d', strtotime('monday this week'));
    log_message2("Processing week: $current_week_start");
    
    // Check if payroll already exists for this week
    $existing_payroll = mysqli_query($con, "SELECT id FROM payrolls WHERE week_start = '$current_week_start'");
    if ($existing_payroll && mysqli_num_rows($existing_payroll) > 0) {
        log_message2("Payroll for week $current_week_start already exists. Skipping.");
        return "Payroll for week $current_week_start already exists.";
    }
    
    $monday = strtotime('last monday', strtotime('tomorrow'));
    $sunday = strtotime('+6 days', $monday);
    $fdate = date("Y-m-d", $monday);
    $tdate = date("Y-m-d", $sunday);
    // $fdate = "2026-02-09";
    // $tdate = "2026-02-15";
    
    $sql1 = "SELECT id FROM weekly_reports_main WHERE week_start = '$fdate' AND week_end = '$tdate'";
    $result1 = mysqli_query($con, $sql1);
    $num_rows1 = mysqli_num_rows($result1);
    if($num_rows1) {
        $row = mysqli_fetch_assoc($result1);
        $weekly_report_main_id = $row["id"];
    } else {
        $sql2 = "INSERT INTO weekly_reports_main(week_start, week_end) VALUES('$fdate', '$tdate')";
        mysqli_query($con, $sql2);
        $weekly_report_main_id = mysqli_insert_id($con); 
    }
    $ch = curl_init();
  curl_setopt($ch, CURLOPT_URL,'https://mtstexting.com/sch-upgraded/api/employees-work-data');
  curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
  //curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post));
  $response = curl_exec($ch);
  $result = json_decode($response, true);
  curl_close($ch); // Close the connection
    if($result["status"]){
        $data = $result["data"];
      foreach($data as $r) {
          echo "<pre>";
          print_r($r);
          echo "</pre>";
        //  exit;
        $solo_hours = $r["worked_single_hours"];
        $regular_hours = $r['hours_worked'];
        
        // Use standard rates
        $mileage_rate = $r["mileage_rate"];
        $solo_bonus_rate = $r["single_hourly_rate"]; // Standard solo bonus rate
        
        $regular_pay = $regular_hours * $r['hourly_rate'];
        $solo_bonus_pay = $solo_hours * $solo_bonus_rate;
        $mileage_pay = $r['total_distance'] * $mileage_rate;
        $gross_pay = $regular_pay + $solo_bonus_pay + $mileage_pay;
        
        $sql3 = "SELECT id FROM weekly_reports WHERE weekly_report_main_id = '$weekly_report_main_id' AND employee_id='".$r['id']."'";
        $result3 = mysqli_query($con, $sql3);
        $num_rows3 = mysqli_num_rows($result3);
        if($num_rows3) {
            $row3 = mysqli_fetch_assoc($result3);
            $weekly_report_id = $row3["id"];
            mysqli_query($con, "
            UPDATE weekly_reports SET 
            employee_id='".$r['id']."', hours_total='".$r['hours_worked']."', solo_hours='".$solo_hours."', miles='".$r['total_distance']."', hourly_rate='".$r['hourly_rate']."', mileage_rate='".$mileage_rate."', solo_bonus_rate='".$solo_bonus_rate."', regular_pay='".$regular_pay."', solo_bonus_pay='".$solo_bonus_pay."', mileage_pay='".$mileage_pay."', gross_pay='".$gross_pay."' WHERE id='$weekly_report_id'");
        } else {
            mysqli_query($con, "
            INSERT INTO weekly_reports 
            (weekly_report_main_id, employee_id, hours_total, solo_hours, miles, hourly_rate, mileage_rate, solo_bonus_rate, regular_pay, solo_bonus_pay, mileage_pay, gross_pay)
            VALUES (
            '".$weekly_report_main_id."',
            '".$r['id']."',
            '".$r['hours_worked']."',
            '".$solo_hours."',
            '".$r['total_distance']."',
            '".$r['hourly_rate']."',
            '".$mileage_rate."',
            '".$solo_bonus_rate."',
            '".$regular_pay."',
            '".$solo_bonus_pay."',
            '".$mileage_pay."',
            '".$gross_pay."')");
        }
      }
}
    exit;
    // Calculate hours and miles from workhistory for active employees
    $work_data_query = mysqli_query($con, "
        SELECT 
            wh.nUserId as employee_id,
            SUM(TIMESTAMPDIFF(HOUR, wh.tStartTime, wh.tEndTime)) as total_hours,
            SUM(wh.nTotalDistance) as total_miles,
            u.dAmount as hourly_rate,
            u.gusto_employee_uuid,
            u.vName as employee_name
        FROM workhistory wh
        JOIN usermst u ON u.id = wh.nUserId
        WHERE 
            u.is_active = 1 
            AND DATE(wh.tStartTime) >= '$current_week_start'
            AND DATE(wh.tEndTime) <= DATE('$current_week_start' + INTERVAL 6 DAY)
            AND u.gusto_employee_uuid IS NOT NULL
        GROUP BY wh.nUserId
    ");
    
    if (!$work_data_query) {
        log_message2("✗ Failed to query work history: " . mysqli_error($con));
        return "Database query failed";
    }
    
    $reports_created = 0;
    $employees_processed = 0;
    
    while ($work_data = mysqli_fetch_assoc($work_data_query)) {
        $employees_processed++;
        
        if ($work_data['total_hours'] > 0 || $work_data['total_miles'] > 0) {
            // For simplicity, assume 20% of hours are solo hours - adjust as needed
            $solo_hours = $work_data['total_hours'] * 0.2;
            $regular_hours = $work_data['total_hours'] - $solo_hours;
            
            // Use standard rates
            $mileage_rate = 0.655; // Standard IRS mileage rate
            $solo_bonus_rate = 3.00; // Standard solo bonus rate
            
            $regular_pay = $regular_hours * $work_data['hourly_rate'];
            $solo_bonus_pay = $solo_hours * $solo_bonus_rate;
            $mileage_pay = $work_data['total_miles'] * $mileage_rate;
            $gross_pay = $regular_pay + $solo_bonus_pay + $mileage_pay;
            
            $stmt = mysqli_prepare($con, "
                INSERT INTO weekly_reports 
                (employee_id, week_start, hours_total, solo_hours, miles, hourly_rate, mileage_rate, solo_bonus_rate, regular_pay, solo_bonus_pay, mileage_pay, gross_pay)
                VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
            ");
            
            if ($stmt) {
                mysqli_stmt_bind_param($stmt, "isdddddddddd", 
                    $work_data['employee_id'], 
                    $current_week_start,
                    $work_data['total_hours'],
                    $solo_hours,
                    $work_data['total_miles'],
                    $work_data['hourly_rate'],
                    $mileage_rate,
                    $solo_bonus_rate,
                    $regular_pay,
                    $solo_bonus_pay,
                    $mileage_pay,
                    $gross_pay
                );
                
                if (mysqli_stmt_execute($stmt)) {
                    $reports_created++;
                    log_message2("✓ Created report for {$work_data['employee_name']}: {$work_data['total_hours']} hours, {$work_data['total_miles']} miles");
                } else {
                    log_message2("✗ Failed to create report for {$work_data['employee_name']}: " . mysqli_stmt_error($stmt));
                }
                mysqli_stmt_close($stmt);
            } else {
                log_message2("✗ Failed to prepare statement for {$work_data['employee_name']}");
            }
        } else {
            log_message2("⚠ No hours/miles for {$work_data['employee_name']}");
        }
    }
    
    log_message2("Processed $employees_processed employees, created $reports_created reports");
    
    if ($reports_created > 0) {
        return "Automatically created $reports_created reports for week $current_week_start";
    } else {
        return "No work data found for automatic payroll processing for week $current_week_start";
    }
}

/**
 * Submit payroll to Gusto
 */
function submitToGusto2($con, $config, $week) {
    log_message2("Submitting payroll to Gusto for week: $week");
    
    // Fetch rows for that week
    $q = "SELECT wr.*, u.gusto_employee_uuid, u.vName as employee_name 
          FROM weekly_reports wr 
          JOIN usermst u ON u.id = wr.employee_id 
          WHERE wr.week_start = '" . mysqli_real_escape_string($con, $week) . "' AND wr.gusto_submitted = 0 AND u.is_active = 1";
    
    $res = mysqli_query($con, $q);
    $rows = [];
    while ($r = mysqli_fetch_assoc($res)) $rows[] = $r;
    
    if (count($rows) == 0) { 
        log_message2("No unsubmitted reports for $week");
        return "No unsubmitted reports for $week";
    }

    $pay_period_start = $week;
    $pay_period_end = date('Y-m-d', strtotime($week . ' +6 days'));
    $pay_date = date('Y-m-d', strtotime($week . ' +11 days'));
    
    // Build employee compensations array for the payroll
    $employee_compensations = [];
    $compensation_errors = [];
    
    foreach ($rows as $row) {
        if (empty($row['gusto_employee_uuid'])) {
            $compensation_errors[] = "Missing gusto_employee_uuid for employee ID: " . $row['employee_id'];
            continue;
        }
        
        // Calculate earnings
        $regular_hours = $row['hours_total'] - $row['solo_hours'];
        $regular_earnings = $regular_hours * ($row['hourly_rate'] ?: 15.00);
        $solo_bonus_earnings = $row['solo_hours'] * ($row['solo_bonus_rate'] ?: 3.00);
        $mileage_reimbursement = $row['miles'] * ($row['mileage_rate'] ?: 0.655);
        
        $earnings = [];
        
        // Add regular hours earning
        if ($regular_hours > 0) {
            $earnings[] = [
                'hours' => (string)number_format($regular_hours, 2),
                'rate' => (string)number_format($row['hourly_rate'] ?: 15.00, 2),
                'earning_type' => 'Regular',
                'amount' => (string)number_format($regular_earnings, 2)
            ];
        }
        
        // Add solo bonus earning
        if ($row['solo_hours'] > 0) {
            $earnings[] = [
                'hours' => (string)number_format($row['solo_hours'], 2),
                'rate' => (string)number_format($row['solo_bonus_rate'] ?: 3.00, 2),
                'earning_type' => 'Bonus',
                'amount' => (string)number_format($solo_bonus_earnings, 2)
            ];
        }
        
        // Add mileage reimbursement
        if ($row['miles'] > 0) {
            $earnings[] = [
                'amount' => (string)number_format($mileage_reimbursement, 2),
                'earning_type' => 'Reimbursement'
            ];
        }
        
        $employee_compensations[] = [
            'employee_uuid' => $row['gusto_employee_uuid'],
            'earnings' => $earnings
        ];
    }
    
    if (empty($employee_compensations)) {
        log_message2("No valid employee compensations to submit");
        return "No valid employee compensations to submit";
    }
    
    // Create payroll WITH employee compensations
    $pay_payload = [
        'start_date' => $pay_period_start,
        'end_date'   => $pay_period_end,
        'pay_date'   => $pay_date,
        'off_cycle'  => true,
        'off_cycle_reason' => 'Bonus',
        'employee_compensations' => $employee_compensations
    ];
    
    log_message2("Creating payroll in Gusto...");
    $create = gusto_request('POST', "companies/{$config->COMPANY_UUID}/payrolls", $pay_payload);
    
    $api_response_json = json_encode($create);
    
    if ($create['http_code'] >= 200 && $create['http_code'] < 300 && !empty($create['json']['uuid'])) {
        $payroll_uuid = $create['json']['uuid'];
        
        // Store payroll with API response
        $stmt = mysqli_prepare($con, "INSERT INTO payrolls (payroll_uuid, company_uuid, week_start, pay_period_start, pay_period_end, pay_date, api_response, status) VALUES (?, ?, ?, ?, ?, ?, ?, 'created')");
        mysqli_stmt_bind_param($stmt, "sssssss", $payroll_uuid, $config->COMPANY_UUID, $week, $pay_period_start, $pay_period_end, $pay_date, $api_response_json);
        mysqli_stmt_execute($stmt);
        mysqli_stmt_close($stmt);

        // Mark all reports as submitted
        foreach ($rows as $row) {
            $update_stmt = mysqli_prepare($con, "UPDATE weekly_reports SET gusto_submitted=1, gusto_payroll_uuid=? WHERE id=?");
            mysqli_stmt_bind_param($update_stmt, "si", $payroll_uuid, $row['id']);
            mysqli_stmt_execute($update_stmt);
            mysqli_stmt_close($update_stmt);
        }

        $result = "✅ Payroll created successfully! UUID: " . substr($payroll_uuid, 0, 8) . "...";
        log_message2($result);
        
        // Try to prepare the payroll
        $prepare = gusto_request('PUT', "companies/{$config->COMPANY_UUID}/payrolls/{$payroll_uuid}/prepare");
        if ($prepare['http_code'] >= 200 && $prepare['http_code'] < 300) {
            $result .= " Payroll prepared successfully.";
            mysqli_query($con, "UPDATE payrolls SET status='prepared' WHERE payroll_uuid='" . mysqli_real_escape_string($con, $payroll_uuid) . "'");
            log_message2("Payroll prepared successfully");
        } else {
            log_message2("Payroll preparation may need manual intervention");
        }
        
        return $result;
        
    } else {
        $error_msg = "❌ Failed to create payroll (HTTP {$create['http_code']}). ";
        if (isset($create['json']['errors'])) {
            foreach ($create['json']['errors'] as $error) {
                $error_msg .= "{$error['message']}. ";
            }
        }
        log_message2($error_msg);
        return $error_msg;
    }
}

// Main execution logic
log_message2("Checking for scheduled payrolls...");

$schedule_check = mysqli_query($con, "SELECT * FROM automatic_payroll_schedule WHERE is_active = 1 AND next_run_date <= CURDATE() LIMIT 1");
if ($schedule_check && mysqli_num_rows($schedule_check) > 0) {
    $schedule = mysqli_fetch_assoc($schedule_check);
    log_message2("Found active schedule: {$schedule['schedule_type']}, next run: {$schedule['next_run_date']}");
    
    // Execute automatic payroll
    $auto_result = executeAutomaticPayroll($con, $config);
    log_message2("Automatic payroll result: $auto_result");
    
    // If reports were created, submit to Gusto
    if (strpos($auto_result, 'created') !== false) {
        $current_week_start = date('Y-m-d', strtotime('monday this week'));
        $gusto_result = submitToGusto2($con, $config, $current_week_start);
        log_message2("Gusto submission result: $gusto_result");
    }
    
    // Update next run date based on schedule type
    $next_run = date('Y-m-d', strtotime("+1 week"));
    if ($schedule['schedule_type'] == 'biweekly') {
        $next_run = date('Y-m-d', strtotime("+2 weeks"));
    } elseif ($schedule['schedule_type'] == 'monthly') {
        $next_run = date('Y-m-d', strtotime("+1 month"));
    }
    
    mysqli_query($con, "UPDATE automatic_payroll_schedule SET next_run_date = '$next_run' WHERE id = {$schedule['id']}");
    log_message2("Updated next run date to: $next_run");
    
} else {
    log_message2("No scheduled payrolls to run today");
}

log_message2("=== Automatic Payroll Processor Completed ===");

// Save log output
$output = ob_get_clean();
file_put_contents(__DIR__ . '/payroll_automation.log', $output, FILE_APPEND);
echo $output;
?>