<?php
require_once 'db.php';

header('Content-Type: application/json');

if (isset($_GET['employee_id'])) {
    $employee_id = intval($_GET['employee_id']);
    
    $query = "SELECT id, vName, dAmount, solo_rate, miles_rate, miscellaneous_rate, custom_fields_rates 
              FROM usermst 
              WHERE id = $employee_id";
    
    $result = mysqli_query($con, $query);
    
    if ($result && mysqli_num_rows($result) > 0) {
        $employee = mysqli_fetch_assoc($con);
        
        $rates = [
            'hourly' => floatval($employee['dAmount'] ?? 16.00),
            'solo' => floatval($employee['solo_rate'] ?? 3.00),
            'miles' => floatval($employee['miles_rate'] ?? 0.25),
            'misc' => floatval($employee['miscellaneous_rate'] ?? 1.00),
            'custom' => json_decode($employee['custom_fields_rates'] ?? '{}', true) ?: []
        ];
        
        echo json_encode([
            'success' => true,
            'name' => $employee['vName'],
            'rates' => $rates
        ]);
    } else {
        echo json_encode(['success' => false, 'error' => 'Employee not found']);
    }
} else {
    echo json_encode(['success' => false, 'error' => 'Employee ID required']);
}