<?php
// Turn on error reporting
// ini_set('display_errors', 1);
// ini_set('display_startup_errors', 1);
// error_reporting(E_ALL);

// Include db first
require_once 'db.php';

// Check login
//session_start();
if (!isset($_SESSION['SESS_MEMBER_ID'])) {
    header('Location: index.php');
    exit;
}

// Include necessary files
require_once 'gusto_api.php';
$config = require __DIR__ . '/gusto_config.php';

// Store flash messages
$success_message = $_SESSION['success'] ?? '';
$error_message = $_SESSION['error'] ?? '';
$warning_message = $_SESSION['warning'] ?? '';
unset($_SESSION['success'], $_SESSION['error'], $_SESSION['warning']);

// Handle form submissions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['add_report'])) {
        // Add manual report with custom fields
        $eid = intval($_POST['employee_id']);
        $week = $_POST['week_start'];
        $hours = floatval($_POST['hours_total']);
        $solo = floatval($_POST['solo_hours'] ?? 0);
        $miles = floatval($_POST['miles'] ?? 0);
        $miscellaneous = floatval($_POST['miscellaneous'] ?? 0);
        
        // Get employee data with custom rates
        $employee_check = mysqli_query($con, "
            SELECT id, vName, dAmount, solo_rate, miles_rate, miscellaneous_rate 
            FROM usermst WHERE id = $eid
        ");
        
        if (!$employee_check || mysqli_num_rows($employee_check) == 0) {
            $_SESSION['error'] = "Employee ID $eid not found!";
            header('Location: gusto_weekly_reports_enhanced.php'); 
            exit;
        }
        
        $employee_data = mysqli_fetch_assoc($employee_check);
        $hrate = floatval($employee_data['dAmount'] ?? 16.00);
        $srate = floatval($employee_data['solo_rate'] ?? 3.00);
        $mrate = floatval($employee_data['miles_rate'] ?? 0.25);
        $misc_rate = floatval($employee_data['miscellaneous_rate'] ?? 1.00);
        
        // Calculate standard pay
        $regular_hours = $hours;
        $regular_pay = $regular_hours * $hrate;
        $solo_bonus_pay = $solo * $srate;
        $mileage_pay = $miles * $mrate;
        $miscellaneous_pay = $miscellaneous * $misc_rate;
        
        // Initialize totals
        $gross_pay = $regular_pay + $solo_bonus_pay + $mileage_pay + $miscellaneous_pay;
        
        // Insert main report
        $stmt = mysqli_prepare($con, "
            INSERT INTO weekly_reports 
            (employee_id, week_start, hours_total, solo_hours, miles, miscellaneous, 
             hourly_rate, mileage_rate, solo_bonus_rate, regular_pay, solo_bonus_pay, 
             mileage_pay, miscellaneous_pay, gross_pay) 
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
        ");
        
        mysqli_stmt_bind_param($stmt, "isdddddddddddd", 
            $eid, $week, $hours, $solo, $miles, $miscellaneous, $hrate, $mrate, $srate, 
            $regular_pay, $solo_bonus_pay, $mileage_pay, $miscellaneous_pay, $gross_pay
        );
        
        if (mysqli_stmt_execute($stmt)) {
            $report_id = mysqli_insert_id($con);
            mysqli_stmt_close($stmt);
            
            $_SESSION['success'] = "✅ Report added successfully! " .
                "Employee: {$employee_data['vName']}, " .
                "Week: $week, " .
                "Gross Pay: $" . number_format($gross_pay, 2);
        } else {
            $_SESSION['error'] = "Error adding report: " . mysqli_error($con);
        }
        
        header('Location: gusto_weekly_reports_enhanced.php'); 
        exit;
    }
    
    // Handle payroll submission
    if (isset($_POST['submit_week'])) {
        $weekly_report_main_id = $_POST['weekly_report_main_id'];
        // Use the enhanced submission function
        $result = submitToGustoEnhanced($con, $config, $weekly_report_main_id);
        if (strpos($result, '✅') !== false) {
            $_SESSION['success'] = $result;
        } else {
            $_SESSION['error'] = $result;
        }
        echo "header location";
        header('location: gusto_weekly_reports_enhanced.php'); 
        exit;
    }
}

// Get sample employees
$sample_employees = mysqli_query($con, "
    SELECT u.id, u.vName, u.dAmount, u.solo_rate, u.miles_rate, u.miscellaneous_rate,
           COUNT(DISTINCT wr.id) as report_count
    FROM usermst u
    LEFT JOIN weekly_reports wr ON wr.employee_id = u.id
    WHERE u.is_active = 1 
    GROUP BY u.id
    ORDER BY u.vName
    LIMIT 15
");

// Get total reports count
$total_reports_result = mysqli_query($con, "SELECT COUNT(*) as total FROM weekly_reports");
$total_reports_data = mysqli_fetch_assoc($total_reports_result);
$total_reports = $total_reports_data['total'];

// Get weeks with unsubmitted reports
$weeks_result = mysqli_query($con, "
    SELECT * FROM weekly_reports_main WHERE submitted_to_gutso = 0");

// Get recent reports
$reports_result = mysqli_query($con, "
    SELECT wr.*, u.vName as employee_name, u.gusto_employee_uuid, m.week_start,m.week_end
    FROM weekly_reports wr 
    JOIN usermst u ON u.id = wr.employee_id
    JOIN weekly_reports_main m ON wr.weekly_report_main_id = m.id
    WHERE u.is_active = 1 
    ORDER BY wr.id DESC 
    LIMIT 50
");
?>

<?php include('includes/head.php'); ?>
<!--
<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h3 class="mb-1">Enhanced Weekly Reports</h3>
        <p class="text-muted mb-0">Add reports with complete pay calculations</p>
    </div>
    <div>
        <a href="gusto_employees.php" class="btn btn-outline-primary">
            <i class="fa fa-users"></i> Employee Management
        </a>
    </div>
</div>
-->
<link href="css/gutso.css" rel='stylesheet' type='text/css' />
<div class="content-container">
    <h1>Enhanced Reports</h1>
    <?php if($success_message): ?>
        <div class="alert alert-success alert-dismissible fade show">
            <?= $success_message ?>
            <button type="button" class="close" data-dismiss="alert">&times;</button>
        </div>
    <?php endif; ?>
    
    <?php if($error_message): ?>
        <div class="alert alert-danger alert-dismissible fade show">
            <?= $error_message ?>
            <button type="button" class="close" data-dismiss="alert">&times;</button>
        </div>
    <?php endif; ?>
    
    <!-- Quick Employee Selection -->
    <?php /* if ($sample_employees && mysqli_num_rows($sample_employees) > 0): ?>
    <div class="card mb-4">
        <div class="card-header bg-primary text-white">
            <h5 class="mb-0"><i class="fa fa-users"></i> Quick Employee Selection</h5>
        </div>
        <div class="card-body">
            <p class="mb-3">Click an employee to auto-fill the form:</p>
            <div class="row">
                <?php while ($emp = mysqli_fetch_assoc($sample_employees)): ?>
                    <div class="col-md-3 mb-3">
                        <button class="btn btn-outline-primary btn-block text-left set-employee" 
                                data-id="<?= $emp['id'] ?>"
                                data-name="<?= htmlspecialchars($emp['vName']) ?>"
                                data-hourly="<?= $emp['dAmount'] ?>"
                                data-solo="<?= $emp['solo_rate'] ?>"
                                data-miles="<?= $emp['miles_rate'] ?>"
                                data-misc="<?= $emp['miscellaneous_rate'] ?>">
                            <div class="d-flex justify-content-between">
                                <strong><?= htmlspecialchars($emp['vName']) ?></strong>
                                <span class="badge badge-info"><?= $emp['report_count'] ?></span>
                            </div>
                            <small>ID: <?= $emp['id'] ?> | $<?= number_format($emp['dAmount'], 2) ?>/hr</small>
                            <div class="mt-1 small">
                                <span class="badge badge-light">Solo: $<?= number_format($emp['solo_rate'], 2) ?></span>
                                <span class="badge badge-light">Miles: $<?= number_format($emp['miles_rate'], 2) ?></span>
                                <span class="badge badge-light">Misc: $<?= number_format($emp['miscellaneous_rate'], 2) ?></span>
                            </div>
                        </button>
                    </div>
                <?php endwhile; ?>
            </div>
        </div>
    </div>
    <?php endif; */ ?>
    <!-- Add Manual Report -->
    <!--
    <div class="card mb-4">
        <div class="card-header bg-success text-white">
            <h5 class="mb-0"><i class="fa fa-plus-circle"></i> Add Weekly Report</h5>
        </div>
        <div class="card-body">
            <form method="post" id="reportForm" class="row g-3">
                <div class="col-md-12">
                    <div class="alert alert-info">
                        <i class="fa fa-info-circle"></i> 
                        <strong>Note:</strong> All calculations are done automatically based on employee rates.
                    </div>
                </div>
                
                <div class="col-md-3">
                    <label class="form-label">Week Start *</label>
                    <input type="date" name="week_start" class="form-control" 
                           value="<?= date('Y-m-d', strtotime('monday this week')) ?>" required>
                </div>
                <div class="col-md-3">
                    <label class="form-label">Employee ID *</label>
                    <div class="input-group">
                        <input type="number" step="1" name="employee_id" id="employee_id" 
                               class="form-control" placeholder="Employee ID" required>
                        <div class="input-group-append">
                            <button type="button" class="btn btn-outline-secondary" 
                                    onclick="loadEmployeeRates()">
                                <i class="fa fa-refresh"></i> Load Rates
                            </button>
                        </div>
                    </div>
                    <small class="text-muted" id="employeeInfo"></small>
                </div>
                
                <div class="col-md-1">
                    <label class="form-label">Hours *</label>
                    <input type="number" step="0.1" name="hours_total" id="hours_total"
                           class="form-control" placeholder="Hours" required>
                </div>
                <div class="col-md-1">
                    <label class="form-label">Solo Hours</label>
                    <input type="number" step="0.1" name="solo_hours" id="solo_hours"
                           class="form-control" placeholder="Solo" value="0">
                </div>
                <div class="col-md-1">
                    <label class="form-label">Miles</label>
                    <input type="number" step="0.1" name="miles" id="miles"
                           class="form-control" placeholder="Miles" value="0">
                </div>
                <div class="col-md-1">
                    <label class="form-label">Misc</label>
                    <input type="number" step="0.1" name="miscellaneous" id="miscellaneous"
                           class="form-control" placeholder="Misc" value="0">
                </div>
                
                <div class="col-md-12 mt-3">
                    <div class="card bg-light">
                        <div class="card-body">
                            <h6>Employee Rates</h6>
                            <div class="row" id="ratesDisplay">
                                <div class="col-md-3">
                                    <small class="text-muted">Hourly Rate:</small>
                                    <div id="hourlyRate">$0.00/hr</div>
                                </div>
                                <div class="col-md-3">
                                    <small class="text-muted">Solo Rate:</small>
                                    <div id="soloRate">$0.00/hr</div>
                                </div>
                                <div class="col-md-3">
                                    <small class="text-muted">Miles Rate:</small>
                                    <div id="milesRate">$0.00/mile</div>
                                </div>
                                <div class="col-md-3">
                                    <small class="text-muted">Misc Rate:</small>
                                    <div id="miscRate">$0.00/unit</div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-12 mt-3">
                    <div class="card bg-light">
                        <div class="card-body">
                            <h6>Pay Summary Preview</h6>
                            <div class="row" id="paySummary">
                                <div class="col-md-3">
                                    <small class="text-muted">Regular Pay:</small>
                                    <div id="regularPay">$0.00</div>
                                </div>
                                <div class="col-md-3">
                                    <small class="text-muted">Solo Bonus:</small>
                                    <div id="soloPay">$0.00</div>
                                </div>
                                <div class="col-md-3">
                                    <small class="text-muted">Mileage:</small>
                                    <div id="mileagePay">$0.00</div>
                                </div>
                                <div class="col-md-3">
                                    <small class="text-muted">Miscellaneous:</small>
                                    <div id="miscPay">$0.00</div>
                                </div>
                                <div class="col-md-12 mt-2">
                                    <hr>
                                    <div class="d-flex justify-content-between">
                                        <strong>Total Gross Pay:</strong>
                                        <strong id="totalGrossPay">$0.00</strong>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-12 mt-3">
                    <button name="add_report" class="btn btn-success btn-lg">
                        <i class="fa fa-check-circle"></i> Add Report
                    </button>
                    <button type="button" class="btn btn-outline-secondary" onclick="calculatePreview()">
                        <i class="fa fa-calculator"></i> Calculate Preview
                    </button>
                </div>
            </form>
        </div>
    </div>
    -->
    <!-- Reports Table -->
    <div class="card">
        <div class="card-header bg-light d-flex justify-content-between align-items-center">
            <h5 class="mb-0">All Reports (<?= $total_reports ?> total)</h5>
            <?php if (mysqli_num_rows($weeks_result) > 0): ?>
            <div>
                <form method="post" class="form-inline">
                    <select name="weekly_report_main_id" class="form-control mr-2">
                        <option value="">Select week to submit...</option>
                        <?php while ($week = mysqli_fetch_assoc($weeks_result)): ?>
                            <option value="<?= $week['id'] ?>">
                                <?= $week['week_start']."-".$week['week_end'] ?> (Unsubmitted)
                            </option>
                        <?php endwhile; ?>
                    </select>
                    <button type="submit" name="submit_week" class="btn btn-primary">
                        <i class="fa fa-paper-plane"></i> Submit to Gusto
                    </button>
                </form>
            </div>
            <?php endif; ?>
        </div>
        <div class="card-body">
            <?php if ($total_reports > 0): ?>
                <div class="table-responsive">
                    <table class="table table-sm table-striped" id="reportsTable">
                        <thead>
                            <tr>
                                <th>Week</th>
                                <th>Employee</th>
                                <th>Hours</th>
                                <th>Solo</th>
                                <th>Miles</th>
                                <th>Misc</th>
                                <th>Regular Pay</th>
                                <th>Solo Bonus</th>
                                <th>Mileage</th>
                                <th>Misc Pay</th>
                                <th>Gross Pay</th>
                                <th>Submitted</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php while($r = mysqli_fetch_assoc($reports_result)): 
                                $row_class = $r['gusto_submitted'] ? 'table-success' : '';
                            ?>
                                <tr class="<?= $row_class ?>">
                                    <td><?= $r['week_start']." - ".$r['week_end'] ?></td>
                                    <td>
                                        <?= $r['employee_name'] ?>
                                        <small class="d-block text-muted">ID: <?= $r['employee_id'] ?></small>
                                    </td>
                                    <td><?= number_format($r['hours_total'], 2)." (".$r["hourly_rate"].")" ?></td>
                                    <td><?= number_format($r['solo_hours'], 2)." (".$r["solo_bonus_rate"].")" ?></td>
                                    <td><?= number_format($r['miles'], 2)." (".$r["mileage_rate"].")" ?></td>
                                    <td><?= number_format($r['miscellaneous'], 2) ?></td>
                                    <td>$<?= number_format($r['regular_pay'], 2) ?></td>
                                    <td>$<?= number_format($r['solo_bonus_pay'], 2) ?></td>
                                    <td>$<?= number_format($r['mileage_pay'], 2) ?></td>
                                    <td>$<?= number_format($r['miscellaneous_pay'], 2) ?></td>
                                    <td>
                                        <strong>$<?= number_format($r['gross_pay'], 2) ?></strong>
                                    </td>
                                    <td>
                                        <?php if($r['gusto_submitted']): ?>
                                            <span class="badge badge-success">Yes</span>
                                            <?php if($r['gusto_payroll_uuid']): ?>
                                                <small class="d-block text-muted">
                                                    <?= substr($r['gusto_payroll_uuid'], 0, 8) ?>...
                                                </small>
                                            <?php endif; ?>
                                        <?php else: ?>
                                            <span class="badge badge-warning">No</span>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                </div>
            <?php else: ?>
                <div class="alert alert-info text-center">
                    <h5>No Reports Yet</h5>
                    <p class="mb-0">Add your first report using the form above.</p>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php include('footer.php'); ?>
<script>
// Employee data cache
let employeeRates = {
    hourly: 16.00,
    solo: 3.00,
    miles: 0.25,
    misc: 1.00,
    name: ''
};

// Initialize
$(document).ready(function() {
    // Set up employee selection
    $('.set-employee').click(function(e) {
        e.preventDefault();
        const employeeId = $(this).data('id');
        const employeeName = $(this).data('name');
        const hourlyRate = $(this).data('hourly');
        const soloRate = $(this).data('solo');
        const milesRate = $(this).data('miles');
        const miscRate = $(this).data('misc');
        
        $('#employee_id').val(employeeId);
        $('#employeeInfo').html(`<i class="fa fa-user"></i> ${employeeName} | $${hourlyRate}/hr`);
        
        // Set employee rates
        employeeRates = {
            hourly: parseFloat(hourlyRate),
            solo: parseFloat(soloRate),
            miles: parseFloat(milesRate),
            misc: parseFloat(miscRate),
            name: employeeName
        };
        
        // Update rates display
        updateRatesDisplay();
        calculatePreview();
    });
    
    // Calculate preview when inputs change
    $('#hours_total, #solo_hours, #miles, #miscellaneous').on('input', calculatePreview);
    
    // Initialize preview
    calculatePreview();
});

function loadEmployeeRates() {
    const employeeId = $('#employee_id').val();
    if (!employeeId) {
        alert('Please enter an Employee ID first');
        return;
    }
    
    $.ajax({
        url: 'get_employee_rates.php',
        type: 'GET',
        data: { employee_id: employeeId },
        success: function(response) {
            if (response.success) {
                employeeRates = response.rates;
                employeeRates.name = response.name;
                $('#employeeInfo').html(`
                    <i class="fa fa-check text-success"></i> 
                    ${response.name} | 
                    Hourly: $${response.rates.hourly} | 
                    Solo: $${response.rates.solo} | 
                    Miles: $${response.rates.miles} | 
                    Misc: $${response.rates.misc}
                `);
                
                updateRatesDisplay();
                calculatePreview();
            } else {
                alert('Employee not found or error loading rates');
                $('#employeeInfo').html('<span class="text-danger">Employee not found</span>');
            }
        },
        error: function() {
            alert('Error loading employee rates');
        }
    });
}

function updateRatesDisplay() {
    $('#hourlyRate').text('$' + employeeRates.hourly.toFixed(2) + '/hr');
    $('#soloRate').text('$' + employeeRates.solo.toFixed(2) + '/hr');
    $('#milesRate').text('$' + employeeRates.miles.toFixed(2) + '/mile');
    $('#miscRate').text('$' + employeeRates.misc.toFixed(2) + '/unit');
}

function calculatePreview() {
    // Get standard values
    const hours = parseFloat($('#hours_total').val()) || 0;
    const solo = parseFloat($('#solo_hours').val()) || 0;
    const miles = parseFloat($('#miles').val()) || 0;
    const misc = parseFloat($('#miscellaneous').val()) || 0;
    
    // Calculate standard pay
    const regularPay = hours * employeeRates.hourly;
    const soloPay = solo * employeeRates.solo;
    const mileagePay = miles * employeeRates.miles;
    const miscPay = misc * employeeRates.misc;
    
    // Calculate final total
    const totalGross = regularPay + soloPay + mileagePay + miscPay;
    
    // Update display
    $('#regularPay').html(`$${regularPay.toFixed(2)}`);
    $('#soloPay').html(`$${soloPay.toFixed(2)}`);
    $('#mileagePay').html(`$${mileagePay.toFixed(2)}`);
    $('#miscPay').html(`$${miscPay.toFixed(2)}`);
    $('#totalGrossPay').html(`$${totalGross.toFixed(2)}`);
}
</script>