<?php
session_start();
if (!isset($_SESSION['SESS_MEMBER_ID'])) { 
    header('Location: index.php'); 
    exit; 
}
require_once 'db.php';

// Create audit table if not exists
@mysqli_query($con, "
    CREATE TABLE IF NOT EXISTS rate_audit_log (
        id INT AUTO_INCREMENT PRIMARY KEY,
        employee_id INT,
        rate_type ENUM('hourly', 'solo', 'miles'),
        old_rate DECIMAL(10,2),
        new_rate DECIMAL(10,2),
        source VARCHAR(255),
        changed_by INT,
        changed_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        FOREIGN KEY (employee_id) REFERENCES usermst(id)
    )
");

// Fetch audit log
$audit_query = mysqli_query($con, "
    SELECT r.*, u.vName as employee_name, uc.vName as changed_by_name
    FROM rate_audit_log r
    LEFT JOIN usermst u ON r.employee_id = u.id
    LEFT JOIN usermst uc ON r.changed_by = uc.id
    ORDER BY r.changed_at DESC
    LIMIT 100
");
?>

<!DOCTYPE HTML>
<html>
<head>
    <title>Rate Audit Log - MaidToSparkle</title>
    <link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <link href="css/bootstrap.min.css" rel='stylesheet' type='text/css' />
    <link href="css/style.css" rel='stylesheet' type='text/css' />
    <link href="css/font-awesome.css" rel="stylesheet"> 
    <style>
        .card {
            border: none;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.08);
        }
        .card-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border-radius: 10px 10px 0 0 !important;
        }
    </style>
</head>
<body class="sticky-header left-side-collapsed">
    <section class="">
        <!-- left side start-->
        <?php include('leftsidebar.php'); ?>
        <!-- left side end--> 
        <!-- main content start-->
        <div class="main-content main-content3">
            <!-- header-starts -->
            <div class="header-section">
                <!--toggle button start-->
                <a class="toggle-btn  menu-collapsed"></a>
                <!--toggle button end-->
                <!--notification menu start -->
                <?php include('menuright.php'); ?>
            </div>
            <!-- //header-ends -->

            <div class="container-fluid">
                <!-- Page Header -->
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <div>
                        <h3 class="mb-1">Rate Change Audit Log</h3>
                        <p class="text-muted mb-0">Track where pay rates are coming from</p>
                    </div>
                    <div class="text-right">
                        <a href="gusto_employees.php" class="btn btn-outline-primary">
                            <i class="fa fa-arrow-left"></i> Back to Employees
                        </a>
                    </div>
                </div>

                <!-- Audit Log Table -->
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0">Recent Rate Changes</h5>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>Date/Time</th>
                                        <th>Employee</th>
                                        <th>Rate Type</th>
                                        <th>Old Rate</th>
                                        <th>New Rate</th>
                                        <th>Source</th>
                                        <th>Changed By</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if(mysqli_num_rows($audit_query) > 0): ?>
                                        <?php while($log = mysqli_fetch_assoc($audit_query)): ?>
                                        <tr>
                                            <td><?= date('M j, Y g:i A', strtotime($log['changed_at'])) ?></td>
                                            <td><?= htmlspecialchars($log['employee_name'] ?? 'N/A') ?></td>
                                            <td>
                                                <span class="badge 
                                                    <?= $log['rate_type'] == 'hourly' ? 'bg-primary' : '' ?>
                                                    <?= $log['rate_type'] == 'solo' ? 'bg-success' : '' ?>
                                                    <?= $log['rate_type'] == 'miles' ? 'bg-info' : '' ?>
                                                ">
                                                    <?= ucfirst($log['rate_type']) ?>
                                                </span>
                                            </td>
                                            <td>$<?= number_format($log['old_rate'], 2) ?></td>
                                            <td>$<?= number_format($log['new_rate'], 2) ?></td>
                                            <td><?= htmlspecialchars($log['source']) ?></td>
                                            <td><?= htmlspecialchars($log['changed_by_name'] ?? 'System') ?></td>
                                        </tr>
                                        <?php endwhile; ?>
                                    <?php else: ?>
                                        <tr>
                                            <td colspan="7" class="text-center py-4">
                                                <div class="text-muted">
                                                    <i class="fa fa-history fa-3x mb-3"></i><br>
                                                    No rate changes recorded yet.
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            
            <?php include('footer.php'); ?>
        </div>
    </section>

    <script src="js/jquery-1.12.4.js"></script>
    <script src="js/bootstrap.min.js"></script>
</body>
</html>