<?php
require_once 'db.php';

// Check a specific user's password format
$test_email = "admin@example.com"; // Replace with your admin email

$query = "SELECT id, vName, vEmail, vPassword, LENGTH(vPassword) as pass_length 
          FROM usermst 
          WHERE vEmail = ? OR vName LIKE ? 
          LIMIT 5";
$stmt = mysqli_prepare($con, $query);
$search_name = "%admin%";
mysqli_stmt_bind_param($stmt, "ss", $test_email, $search_name);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);

echo "<h3>Password Debug Information</h3>";
echo "<table border='1' cellpadding='10'>";
echo "<tr><th>ID</th><th>Name</th><th>Email</th><th>Password Hash</th><th>Length</th><th>Hash Type</th></tr>";

while ($user = mysqli_fetch_assoc($result)) {
    $password_hash = $user['vPassword'];
    $length = $user['pass_length'];
    
    // Try to identify hash type
    $hash_type = "Unknown";
    if ($length == 32 && ctype_xdigit($password_hash)) {
        $hash_type = "MD5";
    } elseif (password_verify('test', $password_hash)) {
        $hash_type = "password_hash()";
    } elseif ($length < 20) {
        $hash_type = "Plain text (possible)";
    }
    
    echo "<tr>";
    echo "<td>" . $user['id'] . "</td>";
    echo "<td>" . htmlspecialchars($user['vName']) . "</td>";
    echo "<td>" . htmlspecialchars($user['vEmail']) . "</td>";
    echo "<td><code>" . substr($password_hash, 0, 20) . "...</code></td>";
    echo "<td>" . $length . "</td>";
    echo "<td>" . $hash_type . "</td>";
    echo "</tr>";
}

echo "</table>";

// Test password verification
echo "<h3>Test Password Verification</h3>";
echo "<form method='post'>";
echo "Test Password: <input type='password' name='test_password'> ";
echo "<input type='submit' value='Test'></form>";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $test_pass = $_POST['test_password'];
    mysqli_data_seek($result, 0); // Reset result pointer
    
    while ($user = mysqli_fetch_assoc($result)) {
        echo "<h4>Testing for: " . htmlspecialchars($user['vEmail']) . "</h4>";
        
        // Test MD5
        if (md5($test_pass) == $user['vPassword']) {
            echo "✓ MD5 match<br>";
        } else {
            echo "✗ MD5 no match<br>";
        }
        
        // Test password_verify
        if (password_verify($test_pass, $user['vPassword'])) {
            echo "✓ password_verify() match<br>";
        } else {
            echo "✗ password_verify() no match<br>";
        }
        
        // Test plain text
        if ($test_pass == $user['vPassword']) {
            echo "✓ Plain text match<br>";
        } else {
            echo "✗ Plain text no match<br>";
        }
        
        echo "Stored hash: " . substr($user['vPassword'], 0, 30) . "...<br>";
        echo "MD5 of input: " . md5($test_pass) . "<br>";
        echo "<hr>";
    }
}
?>