<?php
// get_employee_rates.php
session_start();
if (!isset($_SESSION['GUSTO_SESS_MEMBER_ID'])) {
    header('HTTP/1.1 401 Unauthorized');
    echo json_encode(['success' => false, 'error' => 'Not logged in']);
    exit;
}

require_once 'db.php';

if (!isset($_GET['employee_id'])) {
    echo json_encode(['success' => false, 'error' => 'No employee ID provided']);
    exit;
}

$employee_id = intval($_GET['employee_id']);

// Get employee data with rates
$query = "SELECT id, vName, 
          COALESCE(dAmount, 16.00) as hourly_rate,
          COALESCE(solo_rate, 3.00) as solo_rate,
          COALESCE(miles_rate, 0.25) as miles_rate,
          COALESCE(miscellaneous_rate, 1.00) as miscellaneous_rate
          FROM usermst WHERE id = ? AND is_active = 1";
          
$stmt = mysqli_prepare($con, $query);
mysqli_stmt_bind_param($stmt, "i", $employee_id);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);

if (mysqli_num_rows($result) == 0) {
    echo json_encode(['success' => false, 'error' => 'Employee not found']);
    exit;
}

$employee = mysqli_fetch_assoc($result);

echo json_encode([
    'success' => true,
    'name' => $employee['vName'],
    'rates' => [
        'hourly' => floatval($employee['hourly_rate']),
        'solo' => floatval($employee['solo_rate']),
        'miles' => floatval($employee['miles_rate']),
        'misc' => floatval($employee['miscellaneous_rate'])
    ]
]);
?>