<?php
session_start();
if (!isset($_SESSION['GUSTO_SESS_MEMBER_ID'])) { 
    header('Location: index.php'); 
    exit; 
}

require_once 'db.php';

$message = '';
$token_data = null;

// Fetch current token data for display
$query = "SELECT * FROM gusto_tokens ORDER BY id DESC LIMIT 1";
$result = mysqli_query($con, $query);
if ($result && mysqli_num_rows($result) > 0) {
    $token_data = mysqli_fetch_assoc($result);
} else {
    $message = "No token data found in the database. Please check if the gusto_tokens table has records.";
}

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = mysqli_real_escape_string($con, $_POST['id']);
    $access_token = mysqli_real_escape_string($con, $_POST['access_token']);
    $refresh_token = mysqli_real_escape_string($con, $_POST['refresh_token']);
    $expires_at = mysqli_real_escape_string($con, $_POST['expires_at']);
    $created_at = mysqli_real_escape_string($con, $_POST['created_at']);
    
    // Build the SQL query
    $sql = "UPDATE gusto_tokens SET 
            access_token = '$access_token', 
            refresh_token = '$refresh_token', 
            expires_at = '$expires_at', 
            created_at = '$created_at' 
            WHERE id = '$id'";
    
    // Execute the query
    if (mysqli_query($con, $sql)) {
        if (mysqli_affected_rows($con) > 0) {
            $message = "Token updated successfully!";
            
            // Refresh the token data after update
            $query = "SELECT * FROM gusto_tokens WHERE id = '$id'";
            $result = mysqli_query($con, $query);
            if ($result && mysqli_num_rows($result) > 0) {
                $token_data = mysqli_fetch_assoc($result);
            }
        } else {
            $message = "No changes made. The data might be the same as before.";
        }
    } else {
        $message = "Error updating token: " . mysqli_error($con);
    }
}

// Function to format datetime for input field
function formatDateTimeForInput($datetime) {
    if (empty($datetime)) return '';
    return date('Y-m-d\TH:i', strtotime($datetime));
}
?>

<?php include('header.php'); ?>

<h3><i class="fas fa-key"></i> Update Gusto Tokens</h3>

<div class="row mt-4">
    <div class="col-md-12">
        <?php if ($message): ?>
            <div class="alert alert-<?php 
                if (strpos($message, 'successfully') !== false) echo 'success';
                elseif (strpos($message, 'Error') !== false) echo 'danger';
                else echo 'info';
            ?> alert-dismissible fade show">
                <?php echo htmlspecialchars($message); ?>
                <button type="button" class="close" data-dismiss="alert">&times;</button>
            </div>
        <?php endif; ?>

        <?php if ($token_data): ?>
            <!-- Token Information Card -->
            <div class="card mb-4">
                <div class="card-header bg-info text-white">
                    <h5 class="mb-0"><i class="fas fa-info-circle"></i> Current Token Information</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label class="font-weight-bold">ID</label>
                                <div class="form-control bg-light">
                                    <?php echo htmlspecialchars($token_data['id']); ?>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-9">
                            <div class="form-group">
                                <label class="font-weight-bold">Access Token</label>
                                <div class="input-group">
                                    <input type="text" class="form-control bg-light" 
                                           value="<?php echo htmlspecialchars(substr($token_data['access_token'], 0, 50)); ?>..." readonly>
                                    <div class="input-group-append">
                                        <button class="btn btn-outline-secondary" type="button" 
                                                onclick="copyToClipboard('<?php echo htmlspecialchars($token_data['access_token']); ?>')">
                                            <i class="fas fa-copy"></i> Copy
                                        </button>
                                    </div>
                                </div>
                                <small class="text-muted">Length: <?php echo strlen($token_data['access_token']); ?> characters</small>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="font-weight-bold">Refresh Token</label>
                                <div class="input-group">
                                    <input type="text" class="form-control bg-light" 
                                           value="<?php echo htmlspecialchars(substr($token_data['refresh_token'], 0, 30)); ?>..." readonly>
                                    <div class="input-group-append">
                                        <button class="btn btn-outline-secondary" type="button" 
                                                onclick="copyToClipboard('<?php echo htmlspecialchars($token_data['refresh_token']); ?>')">
                                            <i class="fas fa-copy"></i> Copy
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label class="font-weight-bold">Expires At</label>
                                <div class="form-control bg-light">
                                    <?php echo htmlspecialchars($token_data['expires_at']); ?>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label class="font-weight-bold">Created At</label>
                                <div class="form-control bg-light">
                                    <?php echo htmlspecialchars($token_data['created_at']); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <?php
                    // Calculate time until expiration
                    $expires_time = strtotime($token_data['expires_at']);
                    $current_time = time();
                    $time_until_expiry = $expires_time - $current_time;
                    $hours_until_expiry = floor($time_until_expiry / 3600);
                    $minutes_until_expiry = floor(($time_until_expiry % 3600) / 60);
                    ?>
                    
                    <div class="alert alert-<?php echo $time_until_expiry > 3600 ? 'success' : ($time_until_expiry > 300 ? 'warning' : 'danger'); ?>">
                        <i class="fas fa-clock"></i> 
                        <strong>Token Status:</strong>
                        <?php if ($time_until_expiry > 0): ?>
                            Token expires in 
                            <?php if ($hours_until_expiry > 0): ?>
                                <?php echo $hours_until_expiry; ?> hour<?php echo $hours_until_expiry != 1 ? 's' : ''; ?> 
                            <?php endif; ?>
                            <?php echo $minutes_until_expiry; ?> minute<?php echo $minutes_until_expiry != 1 ? 's' : ''; ?>
                        <?php else: ?>
                            Token expired <?php echo abs($hours_until_expiry); ?> hour<?php echo abs($hours_until_expiry) != 1 ? 's' : ''; ?> ago!
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <!-- Update Form -->
            <div class="card">
                <div class="card-header bg-warning">
                    <h5 class="mb-0"><i class="fas fa-edit"></i> Update Token Information</h5>
                </div>
                <div class="card-body">
                    <form method="POST" action="" id="tokenForm">
                        <div class="row">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="id" class="font-weight-bold">ID</label>
                                    <input type="text" id="id" name="id" 
                                           value="<?php echo htmlspecialchars($token_data['id'] ?? ''); ?>" 
                                           required readonly
                                           class="form-control bg-light">
                                    <small class="text-muted">ID is read-only (primary key)</small>
                                </div>
                            </div>
                            <div class="col-md-9">
                                <div class="form-group">
                                    <label for="access_token" class="font-weight-bold">Access Token *</label>
                                    <input type="text" id="access_token" name="access_token" 
                                           value="<?php echo htmlspecialchars($token_data['access_token'] ?? ''); ?>" 
                                           required
                                           class="form-control"
                                           placeholder="Enter new access token">
                                    <small class="text-muted">Paste the complete access token here</small>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="refresh_token" class="font-weight-bold">Refresh Token *</label>
                                    <input type="text" id="refresh_token" name="refresh_token" 
                                           value="<?php echo htmlspecialchars($token_data['refresh_token'] ?? ''); ?>" 
                                           required
                                           class="form-control"
                                           placeholder="Enter new refresh token">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="expires_at" class="font-weight-bold">Expires At *</label>
                                    <input type="datetime-local" id="expires_at" name="expires_at" 
                                           value="<?php echo formatDateTimeForInput($token_data['expires_at'] ?? ''); ?>" 
                                           required
                                           class="form-control">
                                    <small class="text-muted">Format: YYYY-MM-DD HH:MM:SS</small>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="created_at" class="font-weight-bold">Created At *</label>
                                    <input type="datetime-local" id="created_at" name="created_at" 
                                           value="<?php echo formatDateTimeForInput($token_data['created_at'] ?? ''); ?>" 
                                           required
                                           class="form-control">
                                    <small class="text-muted">Format: YYYY-MM-DD HH:MM:SS</small>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-12">
                                <div class="alert alert-info">
                                    <i class="fas fa-lightbulb"></i>
                                    <strong>Tip:</strong> You can get new tokens from the 
                                    <a href="https://app.gusto-demo.com/oauth/authorize" target="_blank" class="alert-link">
                                        Gusto OAuth authorization page
                                    </a>. Set the redirect URI to: 
                                    <code>https://gpsscheduler.com/gusto/ghook.php</code>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-12 text-right">
                                <button type="button" class="btn btn-secondary" onclick="window.history.back()">
                                    <i class="fas fa-arrow-left"></i> Back
                                </button>
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save"></i> Update Tokens
                                </button>
                                <button type="button" class="btn btn-info" onclick="setFutureExpiry()">
                                    <i class="fas fa-clock"></i> Set 1 Hour Expiry
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

        <?php else: ?>
            <!-- Manual Entry Form -->
            <div class="card">
                <div class="card-header bg-danger text-white">
                    <h5 class="mb-0"><i class="fas fa-exclamation-triangle"></i> No Token Data Found</h5>
                </div>
                <div class="card-body">
                    <div class="alert alert-warning">
                        <strong>No token data found!</strong><br>
                        Please check if:
                        <ul>
                            <li>The gusto_tokens table exists in the database</li>
                            <li>The table has records</li>
                            <li>You have proper database permissions</li>
                        </ul>
                    </div>
                    
                    <h5>Manual Token Entry</h5>
                    <form method="POST" action="">
                        <div class="row">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="id">ID *</label>
                                    <input type="text" id="id" name="id" required class="form-control" 
                                           placeholder="Enter ID (e.g., 1)">
                                </div>
                            </div>
                            <div class="col-md-9">
                                <div class="form-group">
                                    <label for="access_token">Access Token *</label>
                                    <input type="text" id="access_token" name="access_token" required 
                                           class="form-control" placeholder="Enter access token">
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="refresh_token">Refresh Token *</label>
                                    <input type="text" id="refresh_token" name="refresh_token" required 
                                           class="form-control" placeholder="Enter refresh token">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="expires_at">Expires At *</label>
                                    <input type="datetime-local" id="expires_at" name="expires_at" required 
                                           class="form-control">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="created_at">Created At *</label>
                                    <input type="datetime-local" id="created_at" name="created_at" required 
                                           class="form-control">
                                </div>
                            </div>
                        </div>
                        
                        <div class="text-right">
                            <button type="submit" class="btn btn-success">
                                <i class="fas fa-plus-circle"></i> Create/Update Tokens
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        <?php endif; ?>
        
        <div class="mt-4">
            <a href="gusto_employees.php" class="btn btn-outline-secondary">
                <i class="fas fa-arrow-left"></i> Back to Dashboard
            </a>
            <a href="gusto_oauth_start.php" target="_blank" class="btn btn-outline-primary">
                <i class="fas fa-external-link-alt"></i> Get New Tokens
            </a>
        </div>
    </div>
</div>

<?php include('footer.php'); ?>

<style>
.form-control.bg-light {
    background-color: #f8f9fa !important;
    cursor: not-allowed;
}
.toast {
    position: fixed;
    bottom: 20px;
    right: 20px;
    z-index: 9999;
    min-width: 300px;
}
</style>

<script>
// Copy to clipboard function
function copyToClipboard(text) {
    const textarea = document.createElement('textarea');
    textarea.value = text;
    document.body.appendChild(textarea);
    textarea.select();
    document.execCommand('copy');
    document.body.removeChild(textarea);
    
    // Show toast notification
    showToast('Copied to clipboard!');
}

// Set expiry to 1 hour from now
function setFutureExpiry() {
    const now = new Date();
    now.setHours(now.getHours() + 1);
    const expiresAt = document.getElementById('expires_at');
    const created_at = document.getElementById('created_at');
    
    // Format to YYYY-MM-DDTHH:MM
    const formatDate = (date) => {
        return date.toISOString().slice(0, 16);
    };
    
    expiresAt.value = formatDate(now);
    
    // Set created_at to current time
    created_at.value = formatDate(new Date());
    
    showToast('Expiry set to 1 hour from now!');
}

// Show toast notification
function showToast(message) {
    const toast = document.createElement('div');
    toast.className = 'toast';
    toast.innerHTML = `
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="fas fa-check-circle"></i> ${message}
            <button type="button" class="close" data-dismiss="alert">
                &times;
            </button>
        </div>
    `;
    document.body.appendChild(toast);
    
    setTimeout(() => {
        toast.remove();
    }, 3000);
}

// Form validation
document.addEventListener('DOMContentLoaded', function() {
    const form = document.getElementById('tokenForm');
    if (form) {
        form.addEventListener('submit', function(e) {
            const accessToken = document.getElementById('access_token');
            const refreshToken = document.getElementById('refresh_token');
            const expiresAt = document.getElementById('expires_at');
            
            if (!accessToken.value.trim()) {
                alert('Please enter an access token');
                accessToken.focus();
                e.preventDefault();
                return;
            }
            
            if (!refreshToken.value.trim()) {
                alert('Please enter a refresh token');
                refreshToken.focus();
                e.preventDefault();
                return;
            }
            
            if (!expiresAt.value) {
                alert('Please set an expiry date');
                expiresAt.focus();
                e.preventDefault();
                return;
            }
            
            // Confirm update
            if (!confirm('Are you sure you want to update the tokens?')) {
                e.preventDefault();
                return;
            }
        });
    }
    
    // Format datetime inputs on page load
    function formatDateTimeInput(inputId) {
        const input = document.getElementById(inputId);
        if (input && input.value) {
            // Convert to datetime-local format (YYYY-MM-DDTHH:MM)
            const date = new Date(input.value);
            if (!isNaN(date.getTime())) {
                input.value = date.toISOString().slice(0, 16);
            }
        }
    }
    
    formatDateTimeInput('expires_at');
    formatDateTimeInput('created_at');
});
</script>