// Gusto Sidebar Accordion Functionality
document.addEventListener('DOMContentLoaded', function() {
    // Initialize sidebar state
    const sidebar = document.getElementById('gustoSidebar');
    const mainContent = document.querySelector('.gusto-main');
    const toggleBtn = document.getElementById('toggleSidebar');
    
    // Check for mobile view
    function checkMobileView() {
        if (window.innerWidth <= 992) {
            sidebar.classList.add('collapsed');
            sidebar.classList.remove('mobile-open');
            mainContent.classList.add('expanded');
        } else {
            // Restore sidebar state from localStorage or default
            const isCollapsed = localStorage.getItem('gustoSidebarCollapsed') === 'true';
            if (isCollapsed) {
                sidebar.classList.add('collapsed');
                mainContent.classList.add('expanded');
                if (toggleBtn) {
                    toggleBtn.querySelector('i').className = 'fas fa-bars';
                }
            } else {
                sidebar.classList.remove('collapsed');
                mainContent.classList.remove('expanded');
                if (toggleBtn) {
                    toggleBtn.querySelector('i').className = 'fas fa-times';
                }
            }
        }
    }
    
    // Toggle sidebar
    if (toggleBtn) {
        toggleBtn.addEventListener('click', function() {
            sidebar.classList.toggle('collapsed');
            mainContent.classList.toggle('expanded');
            
            // Update icon
            const icon = this.querySelector('i');
            if (sidebar.classList.contains('collapsed')) {
                icon.className = 'fas fa-bars';
                localStorage.setItem('gustoSidebarCollapsed', 'true');
            } else {
                icon.className = 'fas fa-times';
                localStorage.setItem('gustoSidebarCollapsed', 'false');
            }
            
            // Close all submenus when collapsing sidebar
            if (sidebar.classList.contains('collapsed')) {
                document.querySelectorAll('.has-submenu').forEach(function(item) {
                    item.classList.remove('open');
                });
            }
        });
    }
    
    // Accordion functionality for submenus
    document.querySelectorAll('.has-submenu > .nav-link').forEach(function(link) {
        link.addEventListener('click', function(e) {
            e.preventDefault();
            e.stopPropagation();
            
            const parent = this.parentElement;
            const isOpen = parent.classList.contains('open');
            
            // Close all other submenus
            if (!isOpen) {
                document.querySelectorAll('.has-submenu.open').forEach(function(item) {
                    if (item !== parent) {
                        item.classList.remove('open');
                    }
                });
            }
            
            // Toggle current submenu
            parent.classList.toggle('open');
            
            // Update icon rotation
            const icon = this.querySelector('.nav-icon i');
            if (icon) {
                if (parent.classList.contains('open')) {
                    icon.style.transform = 'rotate(180deg)';
                } else {
                    icon.style.transform = 'rotate(0deg)';
                }
            }
        });
    });
    
    // Handle submenu item clicks
    document.querySelectorAll('.nav-submenu .nav-link').forEach(function(link) {
        link.addEventListener('click', function(e) {
            // Remove active class from all menu items
            document.querySelectorAll('.nav-item').forEach(function(item) {
                item.classList.remove('active');
            });
            
            // Add active class to clicked item
            this.parentElement.classList.add('active');
            
            // If mobile view, close sidebar after selection
            if (window.innerWidth <= 992) {
                sidebar.classList.remove('mobile-open');
                sidebar.classList.add('collapsed');
                mainContent.classList.add('expanded');
            }
        });
    });
    
    // Handle main menu item clicks (non-submenu)
    document.querySelectorAll('.nav-item:not(.has-submenu) > .nav-link').forEach(function(link) {
        link.addEventListener('click', function(e) {
            // Remove active class from all menu items
            document.querySelectorAll('.nav-item').forEach(function(item) {
                item.classList.remove('active');
            });
            
            // Add active class to clicked item
            this.parentElement.classList.add('active');
            
            // If mobile view, close sidebar after selection
            if (window.innerWidth <= 992) {
                sidebar.classList.remove('mobile-open');
                sidebar.classList.add('collapsed');
                mainContent.classList.add('expanded');
            }
        });
    });
    
    // Mobile menu toggle
    const mobileToggle = document.createElement('button');
    mobileToggle.className = 'mobile-menu-toggle d-lg-none';
    mobileToggle.innerHTML = '<i class="fas fa-bars"></i>';
    document.querySelector('.gusto-header .header-left').prepend(mobileToggle);
    
    mobileToggle.addEventListener('click', function() {
        sidebar.classList.toggle('mobile-open');
    });
    
    // Close sidebar when clicking outside on mobile
    document.addEventListener('click', function(e) {
        if (window.innerWidth <= 992) {
            if (!sidebar.contains(e.target) && !mobileToggle.contains(e.target)) {
                sidebar.classList.remove('mobile-open');
            }
        }
    });
    
    // Initialize on load
    checkMobileView();
    
    // Handle window resize
    window.addEventListener('resize', checkMobileView);
    
    // Set active menu based on current page
    const currentPage = window.location.pathname.split('/').pop();
    const currentAction = new URLSearchParams(window.location.search).get('action');
    
    // Remove active class from all items first
    document.querySelectorAll('.nav-item').forEach(function(item) {
        item.classList.remove('active');
    });
    
    // Set active based on current page
    document.querySelectorAll('.nav-link').forEach(function(link) {
        const href = link.getAttribute('href');
        if (href) {
            if (href.includes(currentPage) && (currentAction ? href.includes(currentAction) : true)) {
                link.parentElement.classList.add('active');
                
                // If it's in a submenu, open the parent
                const submenuParent = link.closest('.nav-submenu');
                if (submenuParent) {
                    const parentMenuItem = submenuParent.closest('.has-submenu');
                    if (parentMenuItem) {
                        parentMenuItem.classList.add('open');
                    }
                }
            }
        }
    });
});