<?php
if (!isset($_SESSION['GUSTO_SESS_MEMBER_ID'])) {
    return;
}

// Determine active menu
$current_page = basename($_SERVER['PHP_SELF']);
$current_action = isset($_GET['action']) ? $_GET['action'] : '';

// Define menu structure
$menu_items = [
    'dashboard' => [
        'title' => 'Dashboard',
        'icon' => 'fa-tachometer-alt',
        'link' => 'gusto_employees.php',
        'active' => ($current_page == 'gusto_employees.php' && !$current_action)
    ],
    'employees' => [
        'title' => 'Employees',
        'icon' => 'fa-users',
        'submenu' => [
            'add' => [
                'title' => 'Add Employee',
                'icon' => 'fa-user-plus',
                'link' => 'gusto_employees.php?action=create',
                'active' => ($current_page == 'gusto_employees.php' && $current_action == 'create')
            ],
            'list' => [
                'title' => 'View All',
                'icon' => 'fa-list',
                'link' => 'gusto_employees.php',
                'active' => ($current_page == 'gusto_employees.php' && !$current_action)
            ],
            'reports' => [
                'title' => 'Weekly Reports',
                'icon' => 'fa-file-invoice',
                'link' => 'gusto_weekly_reports_enhanced.php',
                'active' => ($current_page == 'gusto_weekly_reports_enhanced.php')
            ]
        ],
        'active' => in_array($current_page, ['gusto_employees.php', 'gusto_weekly_reports_enhanced.php']),
        'open' => in_array($current_page, ['gusto_employees.php', 'gusto_weekly_reports_enhanced.php'])
    ],
    'payroll' => [
        'title' => 'Payroll',
        'icon' => 'fa-money-check-alt',
        'submenu' => [
            'reports' => [
                'title' => 'Payroll Reports',
                'icon' => 'fa-chart-bar',
                'link' => 'gusto_payroll_reports.php',
                'active' => ($current_page == 'gusto_payroll_reports.php' && !$current_action)
            ],
            'submit' => [
                'title' => 'Submit Payroll',
                'icon' => 'fa-paper-plane',
                'link' => 'gusto_payroll_reports.php?action=submit',
                'active' => ($current_page == 'gusto_payroll_reports.php' && $current_action == 'submit')
            ],
            'history' => [
                'title' => 'Payroll History',
                'icon' => 'fa-history',
                'link' => '#',
                'active' => false
            ]
        ],
        'active' => ($current_page == 'gusto_payroll_reports.php'),
        'open' => ($current_page == 'gusto_payroll_reports.php')
    ],
    'custom_fields' => [
        'title' => 'Custom Fields',
        'icon' => 'fa-cogs',
        'link' => 'custom_payroll_fields.php',
        'active' => ($current_page == 'custom_payroll_fields.php')
    ],
    'api' => [
        'title' => 'API Configuration',
        'icon' => 'fa-key',
        'submenu' => [
            'tokens' => [
                'title' => 'API Tokens',
                'icon' => 'fa-key',
                'link' => 'gusto_tocken.php',
                'active' => ($current_page == 'gusto_tocken.php')
            ],
            'config' => [
                'title' => 'Configuration',
                'icon' => 'fa-sliders-h',
                'link' => 'gusto_config.php',
                'active' => ($current_page == 'gusto_config.php')
            ],
            'docs' => [
                'title' => 'API Documentation',
                'icon' => 'fa-code',
                'link' => '#',
                'active' => false
            ]
        ],
        'active' => in_array($current_page, ['gusto_tocken.php', 'gusto_config.php']),
        'open' => in_array($current_page, ['gusto_tocken.php', 'gusto_config.php'])
    ],
    'reports' => [
        'title' => 'Reports & Analytics',
        'icon' => 'fa-chart-line',
        'link' => '#',
        'active' => false
    ],
    'settings' => [
        'title' => 'Profile Settings',
        'icon' => 'fa-user-cog',
        'link' => '#',
        'active' => false
    ],
    'help' => [
        'title' => 'Help & Support',
        'icon' => 'fa-question-circle',
        'link' => '#',
        'active' => false
    ],
    'logout' => [
        'title' => 'Logout',
        'icon' => 'fa-sign-out-alt',
        'link' => 'logout.php',
        'active' => false
    ]
];
?>
<div class="gusto-sidebar" id="gustoSidebar">
    <!-- Sidebar Header -->
    <div class="sidebar-header">
        <a href="gusto_employees.php" class="sidebar-logo">
            <i class="fas fa-briefcase"></i>
            <div>
                <h3>Gusto Payroll</h3>
                <span class="logo-subtitle">MaidToSparkle</span>
            </div>
        </a>
    </div>

    <!-- User Profile -->
    <div class="user-profile">
        <div class="user-avatar">
            <i class="fas fa-user-tie"></i>
        </div>
        <h4 class="user-name"><?php echo htmlspecialchars($_SESSION['GUSTO_SESS_MEMBER_NAME']); ?></h4>
        <p class="user-role">Gusto Administrator</p>
    </div>

    <!-- Navigation Menu -->
    <nav class="sidebar-nav">
        <ul class="nav-list">
            <?php foreach($menu_items as $key => $item): ?>
                <?php if(isset($item['submenu'])): ?>
                    <!-- Menu item with submenu -->
                    <li class="nav-item has-submenu <?php echo $item['open'] ? 'open' : ''; ?> <?php echo $item['active'] ? 'active' : ''; ?>">
                        <a href="#" class="nav-link">
                            <span class="nav-icon"><i class="fas <?php echo $item['icon']; ?>"></i></span>
                            <span class="nav-text"><?php echo $item['title']; ?></span>
                        </a>
                        <ul class="nav-submenu">
                            <?php foreach($item['submenu'] as $sub_key => $sub_item): ?>
                                <li class="nav-item <?php echo $sub_item['active'] ? 'active' : ''; ?>">
                                    <a href="<?php echo $sub_item['link']; ?>" class="nav-link">
                                        <i class="fas <?php echo $sub_item['icon']; ?> me-2"></i>
                                        <?php echo $sub_item['title']; ?>
                                    </a>
                                </li>
                            <?php endforeach; ?>
                        </ul>
                    </li>
                <?php else: ?>
                    <!-- Single menu item -->
                    <li class="nav-item <?php echo $item['active'] ? 'active' : ''; ?>">
                        <a href="<?php echo $item['link']; ?>" class="nav-link <?php echo $key == 'logout' ? 'text-danger' : ''; ?>">
                            <span class="nav-icon"><i class="fas <?php echo $item['icon']; ?>"></i></span>
                            <span class="nav-text"><?php echo $item['title']; ?></span>
                        </a>
                    </li>
                <?php endif; ?>
            <?php endforeach; ?>
        </ul>
    </nav>

    <!-- Sidebar Footer -->
    <div class="sidebar-footer">
        <div class="system-status">
            <span class="status-dot"></span>
            <span>System Online</span>
        </div>
        <div class="last-sync">
            Last sync: <?php echo date('H:i'); ?>
        </div>
    </div>
</div>

<script>
// Initialize active states from PHP
document.addEventListener('DOMContentLoaded', function() {
    // Highlight active menu based on PHP
    const activeItems = document.querySelectorAll('.nav-item.active');
    activeItems.forEach(item => {
        item.classList.add('active');
        
        // If it's in a submenu, open the parent
        const submenuParent = item.closest('.nav-submenu');
        if (submenuParent) {
            const parentMenuItem = submenuParent.closest('.has-submenu');
            if (parentMenuItem) {
                parentMenuItem.classList.add('open');
            }
        }
    });
});
</script>